// twitch-cape-qe-aws - us-east-1
data "aws_vpc" "us_east_1" {
  provider = aws.us-east-1
  id       = "vpc-0c90b72d8697992f4"
}

// us-east-1: Private - us-east-1a
data "aws_subnet" "private_us_east_1a" {
  provider = aws.us-east-1
  id       = "subnet-09b2582d2a5654537"
}

// us-east-1: Private - us-east-1b
data "aws_subnet" "private_us_east_1b" {
  provider = aws.us-east-1
  id       = "subnet-07c93879f67d40c71"
}

// us-east-1 subnet group for Heimdall
resource "aws_db_subnet_group" "heimdall_us_east_1" {
  provider    = aws.us-east-1
  name        = "heimdall"
  description = "Heimdall RDS Databases"
  subnet_ids  = [data.aws_subnet.private_us_east_1a.id, data.aws_subnet.private_us_east_1b.id]

  tags = {
    Repository = "qe/heimdall"
  }
}
