"""This module contains commons functions to interact on page"""
import os
import selenium.webdriver.support.expected_conditions as ec
from selenium.common.exceptions import TimeoutException
from selenium.webdriver.support.wait import WebDriverWait


class BasePage(object):

    """
    Common function to interact with the elements on the page
    """

    def __init__(self, driver):
        self.driver = driver

    def open(self, url):
        """
        Navigates to the given url
        :param url:  url to be navigated
        :return:
        """
        # session_manger = SessionManager()
        if url[0] == '/':
            url = os.environ['base_url'] + url
        self.driver.get(url)

    def wait_for_visible(self, element_locator, timeout=2):
        """
        Wait for the element to be visible
        :param element_locator: element locator
        :param timeout: time to wait for the element
        :return: boolean true/false
        """
        try:
            wait = WebDriverWait(self.driver, timeout)
            wait.until(ec.visibility_of_element_located(element_locator))
            return True
        except TimeoutException:
            return False

    def scroll_screen(page, direction):
        if direction == 'down':
            scroll_script = 'window.scrollTo(0,document.body.scrollHeight);'
        else:
            scroll_script = 'window.scrollTo(0,-document.body.scrollHeight);'
        page.driver.execute_script(scroll_script)
