import collections

from selenium.webdriver.common.by import By

Locator = collections.namedtuple('locator', ('by', 'name'))
ByClass = lambda name: Locator(By.CLASS_NAME, name)
ByXpath = lambda name: Locator(By.XPATH, name)
ById = lambda name: Locator(By.ID, name)
ByCss = lambda name: Locator(By.CSS_SELECTOR, name)
