"""Session Management for mobile."""
import os

import timeout_decorator
from appium import webdriver

from fwk.base.sauce.sauce_util import get_sauce_credential, get_sauce_lab_url


class SessionManager(object):

    """Session Management for different mobile clients."""
    
    base_url = ""
    session_id = ""
    APPIUM_VERSION = '1.7.1'

    def get_mobile_web_session(self, platform, name, version):
        """
        Creates an appium session for requested platform
        :param platform:
        :param name:
        :param version:
        :return:
        """
        desired_caps = {}
        if platform == 'Android':
            desired_caps = self.get_android_caps(name, version)
        elif platform == 'ios':
            desired_caps = self.get_iphone_caps(name, version)

        return webdriver.Remote('http://127.0.0.1:4723/wd/hub', desired_caps)

    def set_session_id(self, session_id):
        self.session_id = session_id

    def get_session_id(self):
        return self.session_id

    # Get the capabilities for android web session
    def get_android_caps(self, name, version):
        """
        Returns the capabilities of Android Web Session
        :param name:
        :param version:
        :return:
        """
        desired_caps = {'platformName': 'Android', 'deviceName': name, 'browserName': 'Chrome',
                        'platformVersion': version}
        return desired_caps

    # Get the capabilities for IOS web session
    def get_iphone_caps(self, name, version):
        """
        Return the capabilities for IOS Web session
        :param name:
        :param version:
        :return:
        """
        desired_caps = {'platformName': 'iOS', 'deviceName': name, 'browserName': 'Safari',
                        'automationName':'XCUITest', 'platformVersion': version}
        return desired_caps

    @timeout_decorator.timeout(240, use_signals=False)
    def get_sauce_session(self, platform_name, device_name, platform_version, browser_name, test_name):
        """
        Creates session for respective platform on sauce cloud.
        :param platform_name:
        :param device_name:
        :param platform_version:
        :param browser_name:
        :param test_name:
        :return:
        """
        desired_capabilities = {}

        if os.environ.has_key("appium_version"):
            appium_version = os.environ['appium_version']
        else:
            appium_version = SessionManager.APPIUM_VERSION

        if platform_name == 'ios':
            desired_capabilities['automationName'] = 'XCUITest'
        else:
            desired_capabilities['automationName'] = 'UiAutomator2'
        credentials = get_sauce_credential()
        desired_capabilities['platformName'] = platform_name
        desired_capabilities['appiumVersion'] = appium_version
        desired_capabilities['platformVersion'] = platform_version
        desired_capabilities['deviceName'] = device_name
        desired_capabilities['browserName'] = browser_name
        desired_capabilities['build'] = os.getenv('build')
        desired_capabilities['tunnelIdentifier'] = os.getenv('sauce_tunnel')
        desired_capabilities['name'] = test_name + "_" + device_name
        url = get_sauce_lab_url(credentials['username'], credentials['password'])
        return webdriver.Remote(url, desired_capabilities)
