import argparse
import json
import subprocess

import sys

import select

parser = argparse.ArgumentParser(description='Sauce connect proxy set up.')
parser.add_argument('-u', action='store', default='',
                    dest='sauce_user',
                    help='sauce username')
parser.add_argument('-k', action='store', default='',
                    dest='sauce_key',
                    help='sauce key')
parser.add_argument('-start', action='store_true', default=False,
                    dest='start_sauce',
                    help='Start the sauce')
parser.add_argument('-stop', action='store_true', default=False,
                    dest='stop_sauce',
                    help='stop the sauce connect')
parser.add_argument('-tunnel', action='store', default='mobile',
                    dest='tunnel_name',
                    help='sauce tunnel name')

results = parser.parse_args()

if results.start_sauce:
    print "start the tunnel"
    # Setting up Sauce Connect 4.x tunnel
    # May need to change ./sc/bin/sc depending on OS and directory structure
    cmd = '/usr/local/bin/sc-4.4.12-linux/bin/sc -u {} -k {} -i {} \
    -B irc-ws.chat.twitch.tv,irc-ws-darklaunch.chat.twitch.tv,pubsub-edge.twitch.tv \
    -f sauce_ready_file'.format(results.sauce_user, results.sauce_key, results.tunnel_name)
    print cmd
    process = subprocess.Popen([cmd], shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    p = process
    print "[Sauce Connect]: Waiting for tunnel setup, this make take up to 30s"

    is_ready = False
    while True:
        reads = [p.stdout.fileno(), p.stderr.fileno()]
        ret = select.select(reads, [], [])

        for fd in ret[0]:
            if fd == p.stdout.fileno():
                read = p.stdout.readline()
                sys.stdout.write("[Sauce Connect]: %s" % read)
                if "Tunnel ID:" in read:
                    tunnel_id = read.split("Tunnel ID: ", 1)[1]
                if "Sauce Connect is up, you may start your tests." in read:
                    print "[Sauce Connect]: Tunnel ready, running the test"
                    is_ready = True
                    break

            if fd == p.stderr.fileno():
                read = p.stderr.readline()
                sys.stderr.write("[Sauce Connect]: %s" % read)
                if "Finished! Deleting tunnel." in read:
                    process.terminate()
                    raise Exception("Sauce Connect could not start!")

        if is_ready:
            break

if results.stop_sauce:
    get_tunnels = 'curl -u {}:{} -X GET https://saucelabs.com/rest/v1/{}/tunnels'\
        .format(results.sauce_user, results.sauce_key, results.sauce_user)
    subprocess.Popen([get_tunnels], shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    output = subprocess.check_output(['bash','-c', get_tunnels])
    print output

    tunnel_ids =  output.split(", ")
    for tunnel_id in tunnel_ids:
        tunnel_id = tunnel_id.replace('"', '').replace('[','').replace(']','')
        get_tunnel = 'curl -u {}:{} -X GET https://saucelabs.com/rest/v1/{}/tunnels/{}'\
            .format(results.sauce_user, results.sauce_key, results.sauce_user, tunnel_id)
        subprocess.Popen([get_tunnel], shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        output = subprocess.check_output(['bash','-c', get_tunnel])
        response = json.loads(output)
        if response['tunnel_identifier'] == results.tunnel_name:
            delete_tunnel = 'curl -u {}:{} -X DELETE https://saucelabs.com/rest/v1/{}/tunnels/{}' \
                    .format(results.sauce_user, results.sauce_key, results.sauce_user, response['id'])
            subprocess.Popen([get_tunnel], shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            output = subprocess.check_output(['bash','-c', delete_tunnel])
