"""Fixtures for test execution"""
import json
import os

import pytest

from fwk.base.sauce.sauce_util import SAUCE_DEVICE_LIST, fetch_test_artifact
from fwk.base.session_manager import SessionManager

SESSION_ID = ""


def pytest_addoption(parser):
    """
    pytest runtime param
    :param parser:
    :return:
    """
    parser.addoption('--platform', metavar='platform', default='Android',
                     help='mobile platform Android/ios')
    parser.addoption('--os_version', metavar='os_version', default='8.0',
                     help='platform version')
    parser.addoption('--name', metavar='version', default='Android Emulator',
                     help='name of the simulator/emulator')
    parser.addoption('--env', metavar='env', default='prod', help='environment')
    parser.addoption('--service', metavar='service', default='aws', help='remote cloud')
    parser.addoption('--build', metavar='build', default='Test', help='build tag')
    parser.addoption('--sauce_tunnel', metavar='sauce_tunnel', default='mobile', help='sauce_tunnel_name')


@pytest.mark.hookwrapper
def pytest_runtest_makereport(item):
    outcome = yield
    rep = outcome.get_result()
    setattr(item, "rep_" + rep.when, rep)

def pytest_configure(config):
    """
    configure pytest
    :param config:
    :return:
    """
    os.environ["platform"] = config.getoption('platform')
    os.environ["version"] = config.getoption('os_version')
    os.environ["name"] = config.getoption('name')
    os.environ["env"] = config.getoption('env')
    os.environ["service"] = config.getoption('service')
    os.environ["build"] = config.getoption('build')
    os.environ["sauce_tunnel"] = config.getoption('sauce_tunnel')
    if os.environ["service"] == 'sauce':
        if os.environ.has_key("sauce_device_list"):
            device_pool = eval(os.environ['sauce_device_list'])
        else:
            device_pool = SAUCE_DEVICE_LIST
    else:
        device_pool = [(os.getenv('platform'), os.getenv('name'),os.getenv('version'))]

    class DynamicFixturePlugin(object):
        @pytest.fixture(scope='function', params=device_pool, autouse=True)
        def driver(self, request):
            session = None
            os.environ["platform"] = request.param[0]
            if os.getenv("env") == 'local':
                 os.environ['base_url'] = 'http://localhost.m.twitch.tv:3003'
            # Run on prod code
            elif os.getenv("env") == 'prod' or os.getenv("env") is None:
                os.environ['base_url'] = 'http://m.twitch.tv'
            session_manager = SessionManager()
            if os.getenv('service') == 'sauce':
                print "******Executing Tests on SAUCE LABS *******"
                try:
                    session = session_manager.get_sauce_session(request.param[0], request.param[1], request.param[2], request.param[3], request.node.name);
                    session_manager.set_session_id(session.session_id)
                    session.implicitly_wait(10)
                    yield session
                finally:
                    if session is not None:
                        session.quit()
                        session_id = session_manager.get_session_id()
                        if request.node.rep_call.failed or request.node.rep_call.skipped:
                            test_folder_name = os.environ["test_results_folder"] + '/failed/' + request.param[1] + '_' \
                                               + request.param[2] + '/' + request.node.name
                            fetch_test_artifact(session_id, test_folder_name, "screenshots")
                            fetch_test_artifact(session_id, test_folder_name, "video")
            else:
                print "******Executing Tests on AWS *******"
                session = session_manager.get_mobile_web_session(os.getenv('platform'), os.getenv('name'),
                                                                os.getenv('version'))
                session.implicitly_wait(10)
                try:
                    yield session
                finally:
                    session.quit()
    config.pluginmanager.register(DynamicFixturePlugin(), 'driver')
