:warning: THIS IS AN ARCHIVED REPO. DO NOT ATTEMPT TO USE IT. :warning:

# oml-service

## API Structure
We use go-swagger to generate from swagger.yml routes and models. Handlers are defined in handlers.go files throughout.
Database management is in db/ and hookups from route to handler are done in configure_oml.go

For API validations, we use swagger. See https://swagger.io/docs/specification/2-0/describing-parameters/ for examples.
The error codes on validation failure are stored in /vendor/github.com/go-openapi/errors/schema.go

## Database structure
Oml-service uses a combination of squirrel and sqlx to manage db queries.
Sqlx provides some niceties like scanning rows directly into a struct.
Squirrel allows programmatic construction of sql, which allows more composition
style creation of queries. In the db folder, there is a db/dbUtil type. All queries are attached
to this object.

To add queries, look for the file for the model you are querying and add a method
to the DBUtil struct. The queries will construct a slice of structs or
return a single struct. If possible, try to return one already defined
in oml-service/models.

To use those queries, import the db module and create
a DBUtil object. Then you will have direct access to the query.

### Why do it this way?

Why have all the db queries here? Go enforces very strong type safety. We already have structs from go-swagger's
generation file which we use to generate responses. 
To cut down on duplicate casting of types from SQL rows
to these structs, the logic in converting to models should be in the querying functions.

Why use squirrel? Squirrel makes it easier to create queries step by step.
This makes the sql logic easier to understand and allows us to deal with 
each parameter independently.
