package db

import (
	sq "gopkg.in/Masterminds/squirrel.v1"

	log "code.justin.tv/qe/oml-service/logger"
	"code.justin.tv/qe/oml-service/models"
)

// GetKpis gets all kpis(key performance indicators) from the db.
func (dbUtil *DBUtil) GetKpis() ([]*models.Kpi, error) {
	kpiQuery, _, err := sq.Select("ID", "PRACTICE_ID", "`KEY`", "NAME").From("KPI").ToSql()
	if err != nil {
		log.Error(err.Error(), "Unable to construct query for retrieving kpis")
		return nil, err
	}
	rows, err := dbUtil.db.Query(kpiQuery)
	if err != nil {
		log.Error(err.Error(), "Unable to retrieve Kpis from DB")
		return nil, err
	}
	defer rows.Close()

	var kpis []*models.Kpi
	for rows.Next() {
		var kpi models.Kpi
		err := rows.Scan(&kpi.ID, &kpi.PracticeID, &kpi.Key, &kpi.Name)
		if err != nil {
			log.Error(err.Error(), "Unable to parse kpi from DB")
			return nil, err
		}
		kpis = append(kpis, &kpi)
	}

	return kpis, nil
}
