package db

import (
	sq "gopkg.in/Masterminds/squirrel.v1"

	log "code.justin.tv/qe/oml-service/logger"
	"code.justin.tv/qe/oml-service/models"
)

// GetMetrics returns all data oml has for the given rollup(org, team, repo, etc.) level and ingestDate
func (dbUtil *DBUtil) GetMetrics(kpiId *int64, ingestDate string) ([]*models.Metrics, error) {
	query := sq.Select("INGEST_BATCH", "ROLLUP_ID", "OML_BU_ID", "OML_TEAM_ID", "OML_SERVICE_ID",
		"GHE_REPO_ID", "KPI_ID", "VALUE1", "VALUE2", "COMPUTED_VALUE", "OML_LEVEL").
		From("METRICS_SUMMARY").
		Where(sq.Eq{"INGEST_BATCH": ingestDate}).
		Where(sq.Eq{"KPI_ID": kpiId})
		

	queryString, args, err := query.ToSql()
	if err != nil {
		log.Error(err.Error(), "Could not Parse args into SQL in metrics summary")
		return nil, err
	}

	rows, err := dbUtil.db.Query(queryString, args...)
	if err != nil {
		log.Error(err.Error(), "Could not retrieve data on metrics summary from db")
		return nil, err
	}

	var metricSummaries []*models.Metrics
	for rows.Next() {
		var metricSummary models.Metrics

		err := rows.Scan(&metricSummary.IngestBatch, &metricSummary.RollupID, &metricSummary.OmlBuID,
			&metricSummary.OmlTeamID, &metricSummary.OmlServiceID, &metricSummary.GheRepoID, &metricSummary.KpiID,
			&metricSummary.Value1, &metricSummary.Value2, &metricSummary.ComputedValue, &metricSummary.OmlLevel)
		if err != nil {
			log.Error(err.Error(), "could not read metric Summary from DB")
			return nil, err
		}

		metricSummaries = append(metricSummaries, &metricSummary)
	}

	return metricSummaries, nil
}
