package db

import (
	sq "gopkg.in/Masterminds/squirrel.v1"

	"code.justin.tv/qe/oml-service/models"
	log "code.justin.tv/qe/oml-service/logger"

	"errors"
)

// GetOrg returns team lead/owner info oml has for the given business unit or team
func (dbUtil *DBUtil) GetOrg(omlBuID *int64, omlTeamID *int64) ([]*models.Org, error) {
	query := sq.Select("BU.ID", "BU.NAME", "T.ID", "T.NAME", "T.ENG_LEAD").From("OML_TEAM T").
		Join("OML_BU BU ON (T.OML_BU_ID=BU.ID)")

	if omlBuID != nil && omlTeamID != nil {
		e := errors.New("you cannot provide both BuID and omlTeamID to this query")
		log.Error(e.Error())
		return nil, e
	} else if omlBuID != nil {
		query = query.Where(sq.Eq{"BU.ID": omlBuID})
	} else if omlTeamID != nil {
		query = query.Where(sq.Eq{"T.ID": omlTeamID})
	}

	queryString, args, err := query.ToSql()
	if err != nil {
		log.Error(err.Error(), "Could not Parse args into SQL in retrieving org")
		return nil, err
	}

	rows, err := dbUtil.db.Query(queryString, args...)
	if err != nil {
		log.Error(err.Error(), "Could not retrieve org data from db")
		return nil, err
	}

	var orgs []*models.Org
	for rows.Next() {
		var org models.Org

		err := rows.Scan(&org.OmlBuID, &org.OmlBuName, &org.OmlTeamID, &org.OmlTeamName, &org.Owner)
		if err != nil {
			log.Error(err.Error(), "could not read org data from DB")
			return nil, err
		}

		orgs = append(orgs, &org)
	}

	return orgs, nil
}
