package db

import (
	sq "gopkg.in/Masterminds/squirrel.v1"


	log "code.justin.tv/qe/oml-service/logger"
	"code.justin.tv/qe/oml-service/models"
)

// GetPractices gets all best practices for operational maturity from the db.
func (dbUtil *DBUtil) GetPractices() ([]*models.Practice, error) {
	practiceQuery, _, err := sq.Select("ID", "NAME").From("PRACTICE").ToSql()
	if err != nil {
		log.Error(err.Error(), "Unable to construct query for retrieving practices")
		return nil, err
	}
	rows, err := dbUtil.db.Query(practiceQuery)
	if err != nil {
		log.Error(err.Error(), "Unable to retrieve Practices from DB")
		return nil, err
	}
	defer rows.Close()

	var practices []*models.Practice
	for rows.Next() {
		var practice models.Practice
		err := rows.Scan(&practice.ID, &practice.Name)
		if err != nil {
			log.Error(err.Error(), "Unable to parse practice from DB")
			return nil, err
		}
		practices = append(practices, &practice)
	}

	return practices, nil
}
