package db

import (
sq "gopkg.in/Masterminds/squirrel.v1"

log "code.justin.tv/qe/oml-service/logger"

"code.justin.tv/qe/oml-service/models"
)

// GetRepos gets all org rollup levels from db.
func (dbUtil *DBUtil) GetRepos() ([]*models.Repo, error) {
	repoQuery, _, err := sq.Select("ID", "NAME", "OML_TEAM_ID").From("GHE_REPO").ToSql()
	if err != nil {
		log.Error(err.Error(), "Unable to construct query for retrieving repos")
		return nil, err
	}
	rows, err := dbUtil.db.Query(repoQuery)
	if err != nil {
		log.Error(err.Error(), "Unable to retrieve Repos from DB")
		return nil, err
	}
	defer rows.Close()

	var repos []*models.Repo
	for rows.Next() {
		var repo models.Repo
		err := rows.Scan(&repo.ID, &repo.Name, &repo.OmlTeamID)
		if err != nil {
			log.Error(err.Error(), "Unable to parse repo from DB")
			return nil, err
		}
		repos = append(repos, &repo)
	}

	return repos, nil
}
