package db

import (
	sq "gopkg.in/Masterminds/squirrel.v1"

	log "code.justin.tv/qe/oml-service/logger"

	"code.justin.tv/qe/oml-service/models"
)

// GetRollups gets all org rollup levels from db.
func (dbUtil *DBUtil) GetRollups() ([]*models.Rollup, error) {
	rollupQuery, _, err := sq.Select("ID", "NAME").From("ROLLUP").ToSql()
	if err != nil {
		log.Error(err.Error(), "Unable to construct query for retrieving rollups")
		return nil, err
	}
	rows, err := dbUtil.db.Query(rollupQuery)
	if err != nil {
		log.Error(err.Error(), "Unable to retrieve Rollups from DB")
		return nil, err
	}
	defer rows.Close()

	var rollups []*models.Rollup
	for rows.Next() {
		var rollup models.Rollup
		err := rows.Scan(&rollup.ID, &rollup.Name)
		if err != nil {
			log.Error(err.Error(), "Unable to parse rollup from DB")
			return nil, err
		}
		rollups = append(rollups, &rollup)
	}

	return rollups, nil
}
