package logger

import (
    "testing"
    "github.com/heroku/rollrus"
    "github.com/sirupsen/logrus"
    "github.com/golang/mock/gomock"
)

var (
    testToken = "testToken"
    testEnv = "testEnv"
)

func TestGetSyncHook(t *testing.T) {
    called := false

    newRollrusHook = func(token string, env string, levels []logrus.Level) *rollrus.Hook {
        called = true
        if testToken != token || env != testEnv {
            t.Fatalf("The args token and env do not match with what we expect")
        }

        return rollrus.NewHookForLevels(token, env, levels)
    }
    _ = GetSyncHook(testToken, testEnv)
    if !called {
        t.Fatalf("Rollrus hook was not called while trying to create sync hook")
    }
}

func TestGetAsyncHook(t *testing.T) {
    mockController := gomock.NewController(t)
    mockHook := NewMockHook(mockController)
    getLogrusSyncHook = func(token string, env string) logrus.Hook {
        return mockHook
    }
    h := GetAsyncHook(testToken, testEnv)
    mockHook.EXPECT().Levels().Times(1)
    h.Levels()

    logEntry := logrus.Entry{}
    h.Fire(&logEntry)
    mockHook.EXPECT().Fire(&logEntry)
    h.Wait()
    mockController.Finish()
}