package main

import (
	"log"
	"code.justin.tv/common/config"
	// "code.justin.tv/foundation/twitchserver"  //TODO: some day we need to integrate with twitchserver
	"github.com/go-openapi/loads"
	"flag"
	"code.justin.tv/qe/oml-service/restapi"
	"code.justin.tv/qe/oml-service/restapi/operations"
)

func main() {
	// To add app-specific config flags, you can call config.Register()
	// https://godoc.internal.justin.tv/code.justin.tv/common/config
	err := config.Parse()
	if err != nil {
		log.Fatal(err)
	}

	// load embedded swagger file
	swaggerSpec, err := loads.Analyzed(restapi.SwaggerJSON, "")
	if err != nil {
		log.Fatalln(err)
	}

	// create new service API
	api := operations.NewOMLAPI(swaggerSpec)
	server := restapi.NewServer(api)
	defer server.Shutdown()

	// configure the api server from Twitch's framework point of view (code.justin.tv/common/config)
	// set the port this service will be run on
	server.Port = 8000  //TODO: read in from config (code.justin.tv/common/config)

	// configure the api server from Swagger's point of view
	flag.Parse()
	server.ConfigureAPI()

	// serve API
	if err := server.Serve(); err != nil {
		log.Fatalln(err)
	}
}
