// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Kpi kpi
// swagger:model kpi
type Kpi struct {

	// id
	// Required: true
	// Read Only: true
	ID int64 `json:"id"`

	// key
	// Max Length: 12
	// Min Length: 1
	Key string `json:"key,omitempty"`

	// name
	// Max Length: 100
	// Min Length: 1
	Name string `json:"name,omitempty"`

	// practice id
	// Required: true
	// Read Only: true
	PracticeID int64 `json:"practice_id"`
}

// Validate validates this kpi
func (m *Kpi) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateKey(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validatePracticeID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Kpi) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", int64(m.ID)); err != nil {
		return err
	}

	return nil
}

func (m *Kpi) validateKey(formats strfmt.Registry) error {

	if swag.IsZero(m.Key) { // not required
		return nil
	}

	if err := validate.MinLength("key", "body", string(m.Key), 1); err != nil {
		return err
	}

	if err := validate.MaxLength("key", "body", string(m.Key), 12); err != nil {
		return err
	}

	return nil
}

func (m *Kpi) validateName(formats strfmt.Registry) error {

	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", string(m.Name), 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", string(m.Name), 100); err != nil {
		return err
	}

	return nil
}

func (m *Kpi) validatePracticeID(formats strfmt.Registry) error {

	if err := validate.Required("practice_id", "body", int64(m.PracticeID)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Kpi) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Kpi) UnmarshalBinary(b []byte) error {
	var res Kpi
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
