// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MetricsSummary metrics summary
// swagger:model metrics_summary
type MetricsSummary struct {

	// computed value
	// Required: true
	// Read Only: true
	ComputedValue float32 `json:"computed_value"`

	// ghe repo id
	// Required: true
	// Read Only: true
	GheRepoID *int64 `json:"ghe_repo_id"`

	// ingest batch
	// Required: true
	// Read Only: true
	// Max Length: 19
	// Min Length: 1
	IngestBatch string `json:"ingest_batch"`

	// kpi id
	// Required: true
	// Read Only: true
	KpiID int64 `json:"kpi_id"`

	// oml bu id
	// Required: true
	// Read Only: true
	OmlBuID *int64 `json:"oml_bu_id"`

	// oml level
	// Required: true
	// Read Only: true
	OmlLevel *int64 `json:"oml_level"`

	// oml service id
	// Required: true
	// Read Only: true
	OmlServiceID *int64 `json:"oml_service_id"`

	// oml team id
	// Required: true
	// Read Only: true
	OmlTeamID *int64 `json:"oml_team_id"`

	// rollup id
	// Required: true
	// Read Only: true
	RollupID *int64 `json:"rollup_id"`

	// value1
	// Required: true
	// Read Only: true
	Value1 float32 `json:"value1"`

	// value2
	// Required: true
	// Read Only: true
	Value2 float32 `json:"value2"`
}

// Validate validates this metrics summary
func (m *MetricsSummary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComputedValue(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateGheRepoID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateIngestBatch(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateKpiID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateOmlBuID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateOmlLevel(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateOmlServiceID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateOmlTeamID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateRollupID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateValue1(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateValue2(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetricsSummary) validateComputedValue(formats strfmt.Registry) error {

	if err := validate.Required("computed_value", "body", float32(m.ComputedValue)); err != nil {
		return err
	}

	return nil
}

func (m *MetricsSummary) validateGheRepoID(formats strfmt.Registry) error {

	if err := validate.Required("ghe_repo_id", "body", m.GheRepoID); err != nil {
		return err
	}

	return nil
}

func (m *MetricsSummary) validateIngestBatch(formats strfmt.Registry) error {

	if err := validate.RequiredString("ingest_batch", "body", string(m.IngestBatch)); err != nil {
		return err
	}

	if err := validate.MinLength("ingest_batch", "body", string(m.IngestBatch), 1); err != nil {
		return err
	}

	if err := validate.MaxLength("ingest_batch", "body", string(m.IngestBatch), 19); err != nil {
		return err
	}

	return nil
}

func (m *MetricsSummary) validateKpiID(formats strfmt.Registry) error {

	if err := validate.Required("kpi_id", "body", int64(m.KpiID)); err != nil {
		return err
	}

	return nil
}

func (m *MetricsSummary) validateOmlBuID(formats strfmt.Registry) error {

	if err := validate.Required("oml_bu_id", "body", m.OmlBuID); err != nil {
		return err
	}

	return nil
}

func (m *MetricsSummary) validateOmlLevel(formats strfmt.Registry) error {

	if err := validate.Required("oml_level", "body", m.OmlLevel); err != nil {
		return err
	}

	return nil
}

func (m *MetricsSummary) validateOmlServiceID(formats strfmt.Registry) error {

	if err := validate.Required("oml_service_id", "body", m.OmlServiceID); err != nil {
		return err
	}

	return nil
}

func (m *MetricsSummary) validateOmlTeamID(formats strfmt.Registry) error {

	if err := validate.Required("oml_team_id", "body", m.OmlTeamID); err != nil {
		return err
	}

	return nil
}

func (m *MetricsSummary) validateRollupID(formats strfmt.Registry) error {

	if err := validate.Required("rollup_id", "body", m.RollupID); err != nil {
		return err
	}

	return nil
}

func (m *MetricsSummary) validateValue1(formats strfmt.Registry) error {

	if err := validate.Required("value1", "body", float32(m.Value1)); err != nil {
		return err
	}

	return nil
}

func (m *MetricsSummary) validateValue2(formats strfmt.Registry) error {

	if err := validate.Required("value2", "body", float32(m.Value2)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetricsSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetricsSummary) UnmarshalBinary(b []byte) error {
	var res MetricsSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
