// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Org org
// swagger:model org
type Org struct {

	// oml bu id
	// Required: true
	// Read Only: true
	OmlBuID int64 `json:"oml_bu_id"`

	// oml bu name
	// Max Length: 50
	// Min Length: 1
	OmlBuName string `json:"oml_bu_name,omitempty"`

	// oml team id
	// Required: true
	// Read Only: true
	OmlTeamID int64 `json:"oml_team_id"`

	// oml team name
	// Max Length: 50
	// Min Length: 1
	OmlTeamName string `json:"oml_team_name,omitempty"`

	// owner
	// Max Length: 50
	// Min Length: 1
	Owner *string `json:"owner,omitempty"`
}

// Validate validates this org
func (m *Org) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateOmlBuID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateOmlBuName(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateOmlTeamID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateOmlTeamName(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Org) validateOmlBuID(formats strfmt.Registry) error {

	if err := validate.Required("oml_bu_id", "body", int64(m.OmlBuID)); err != nil {
		return err
	}

	return nil
}

func (m *Org) validateOmlBuName(formats strfmt.Registry) error {

	if swag.IsZero(m.OmlBuName) { // not required
		return nil
	}

	if err := validate.MinLength("oml_bu_name", "body", string(m.OmlBuName), 1); err != nil {
		return err
	}

	if err := validate.MaxLength("oml_bu_name", "body", string(m.OmlBuName), 50); err != nil {
		return err
	}

	return nil
}

func (m *Org) validateOmlTeamID(formats strfmt.Registry) error {

	if err := validate.Required("oml_team_id", "body", int64(m.OmlTeamID)); err != nil {
		return err
	}

	return nil
}

func (m *Org) validateOmlTeamName(formats strfmt.Registry) error {

	if swag.IsZero(m.OmlTeamName) { // not required
		return nil
	}

	if err := validate.MinLength("oml_team_name", "body", string(m.OmlTeamName), 1); err != nil {
		return err
	}

	if err := validate.MaxLength("oml_team_name", "body", string(m.OmlTeamName), 50); err != nil {
		return err
	}

	return nil
}

func (m *Org) validateOwner(formats strfmt.Registry) error {

	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if err := validate.MinLength("owner", "body", string(*m.Owner), 1); err != nil {
		return err
	}

	if err := validate.MaxLength("owner", "body", string(*m.Owner), 50); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Org) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Org) UnmarshalBinary(b []byte) error {
	var res Org
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
