// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Repo repo
// swagger:model repo
type Repo struct {

	// id
	// Required: true
	// Read Only: true
	ID int64 `json:"id"`

	// name
	// Required: true
	// Max Length: 50
	// Min Length: 1
	Name *string `json:"name"`

	// oml team id
	// Required: true
	// Read Only: true
	OmlTeamID int64 `json:"oml_team_id"`
}

// Validate validates this repo
func (m *Repo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateOmlTeamID(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Repo) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", int64(m.ID)); err != nil {
		return err
	}

	return nil
}

func (m *Repo) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.MinLength("name", "body", string(*m.Name), 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", string(*m.Name), 50); err != nil {
		return err
	}

	return nil
}

func (m *Repo) validateOmlTeamID(formats strfmt.Registry) error {

	if err := validate.Required("oml_team_id", "body", int64(m.OmlTeamID)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Repo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Repo) UnmarshalBinary(b []byte) error {
	var res Repo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
