// Code generated by go-swagger; DO NOT EDIT.

package restapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

// SwaggerJSON embedded version of the swagger document used at generation time
var SwaggerJSON json.RawMessage

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/tv.twitch.oml.v1+json",
    "application/json"
  ],
  "produces": [
    "application/tv.twitch.oml.v1+json",
    "application/json"
  ],
  "schemes": [
    "http"
  ],
  "swagger": "2.0",
  "info": {
    "description": "OML service provides RESTful interface to OML data",
    "title": "OML service",
    "version": "0.0.1"
  },
  "paths": {
    "/": {
      "get": {
        "description": "Dummy Endpoint. Always return HTTP 200",
        "responses": {
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/kpis": {
      "get": {
        "description": "Queries the Key Performance Indicators, which are used to measure effective achievement of Practices.",
        "tags": [
          "kpis"
        ],
        "responses": {
          "200": {
            "description": "List the KPIs",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/kpi"
              }
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/metrics": {
      "get": {
        "description": "Queries the Metrics Summary data for a specific KPI and date.",
        "tags": [
          "metrics"
        ],
        "parameters": [
          {
            "type": "integer",
            "format": "int64",
            "name": "kpi_id",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Get the metrics for this given date. Date is of YYYY-MM-DD format",
            "name": "ingest_date",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/metrics"
              }
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/metrics_summary": {
      "get": {
        "description": "Queries the Metrics Summary data. The output can be filtered by rollup_id, oml_bu_id and oml_team_id.",
        "tags": [
          "metrics_summary"
        ],
        "parameters": [
          {
            "type": "integer",
            "format": "int64",
            "name": "rollup_id",
            "in": "query",
            "required": true
          },
          {
            "type": "integer",
            "format": "int64",
            "name": "oml_bu_id",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "name": "oml_team_id",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Get the metrics summary for this given date. Date is of YYYY-MM-DD format",
            "name": "ingest_date",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/metrics_summary"
              }
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/org": {
      "get": {
        "description": "Queries the normalized Org Structure which contains references to BUs and Teams. The output can be filtered by oml_bu_id and oml_team_id",
        "tags": [
          "org"
        ],
        "parameters": [
          {
            "type": "integer",
            "format": "int64",
            "name": "oml_bu_id",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "name": "oml_team_id",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/org"
              }
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/practices": {
      "get": {
        "description": "Queries the OML Practices, which are the top level strategic goals.",
        "tags": [
          "practices"
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/practice"
              }
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/repos": {
      "get": {
        "description": "Queries the Repos.",
        "tags": [
          "repos"
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/repo"
              }
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/rollups": {
      "get": {
        "description": "Queries the Rollup levels.",
        "tags": [
          "rollups"
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/rollup"
              }
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "error": {
      "type": "object",
      "required": [
        "code",
        "message"
      ],
      "properties": {
        "code": {
          "type": "integer",
          "format": "int64"
        },
        "message": {
          "type": "string"
        }
      }
    },
    "kpi": {
      "type": "object",
      "required": [
        "id",
        "practice_id"
      ],
      "properties": {
        "id": {
          "type": "integer",
          "format": "int64",
          "readOnly": true
        },
        "key": {
          "type": "string",
          "maxLength": 12,
          "minLength": 1
        },
        "name": {
          "type": "string",
          "maxLength": 100,
          "minLength": 1
        },
        "practice_id": {
          "type": "integer",
          "format": "int64",
          "readOnly": true
        }
      }
    },
    "metrics": {
      "type": "object",
      "required": [
        "kpi_id",
        "ingest_batch",
        "rollup_id",
        "oml_bu_id",
        "oml_team_id",
        "oml_service_id",
        "ghe_repo_id",
        "value1",
        "value2",
        "computed_value",
        "oml_level"
      ],
      "properties": {
        "computed_value": {
          "type": "number",
          "format": "float",
          "readOnly": true
        },
        "ghe_repo_id": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "ingest_batch": {
          "type": "string",
          "maxLength": 19,
          "minLength": 1,
          "readOnly": true
        },
        "kpi_id": {
          "type": "integer",
          "format": "int64",
          "readOnly": true
        },
        "oml_bu_id": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "oml_level": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "oml_service_id": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "oml_team_id": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "rollup_id": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "value1": {
          "type": "number",
          "format": "float",
          "readOnly": true
        },
        "value2": {
          "type": "number",
          "format": "float",
          "readOnly": true
        }
      }
    },
    "metrics_summary": {
      "type": "object",
      "required": [
        "kpi_id",
        "ingest_batch",
        "rollup_id",
        "oml_bu_id",
        "oml_team_id",
        "oml_service_id",
        "ghe_repo_id",
        "value1",
        "value2",
        "computed_value",
        "oml_level"
      ],
      "properties": {
        "computed_value": {
          "type": "number",
          "format": "float",
          "readOnly": true
        },
        "ghe_repo_id": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "ingest_batch": {
          "type": "string",
          "maxLength": 19,
          "minLength": 1,
          "readOnly": true
        },
        "kpi_id": {
          "type": "integer",
          "format": "int64",
          "readOnly": true
        },
        "oml_bu_id": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "oml_level": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "oml_service_id": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "oml_team_id": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "rollup_id": {
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "readOnly": true
        },
        "value1": {
          "type": "number",
          "format": "float",
          "readOnly": true
        },
        "value2": {
          "type": "number",
          "format": "float",
          "readOnly": true
        }
      }
    },
    "org": {
      "type": "object",
      "required": [
        "oml_bu_id",
        "oml_team_id"
      ],
      "properties": {
        "oml_bu_id": {
          "type": "integer",
          "format": "int64",
          "readOnly": true
        },
        "oml_bu_name": {
          "type": "string",
          "maxLength": 50,
          "minLength": 1
        },
        "oml_team_id": {
          "type": "integer",
          "format": "int64",
          "readOnly": true
        },
        "oml_team_name": {
          "type": "string",
          "maxLength": 50,
          "minLength": 1
        },
        "owner": {
          "type": "string",
          "maxLength": 50,
          "minLength": 1,
          "x-nullable": true
        }
      }
    },
    "practice": {
      "type": "object",
      "required": [
        "id"
      ],
      "properties": {
        "id": {
          "type": "integer",
          "format": "int64",
          "readOnly": true
        },
        "name": {
          "type": "string",
          "maxLength": 100,
          "minLength": 1
        }
      }
    },
    "repo": {
      "type": "object",
      "required": [
        "id",
        "name",
        "oml_team_id"
      ],
      "properties": {
        "id": {
          "type": "integer",
          "format": "int64",
          "readOnly": true
        },
        "name": {
          "type": "string",
          "maxLength": 50,
          "minLength": 1
        },
        "oml_team_id": {
          "type": "integer",
          "format": "int64",
          "readOnly": true
        }
      }
    },
    "rollup": {
      "type": "object",
      "required": [
        "id"
      ],
      "properties": {
        "id": {
          "type": "integer",
          "format": "int64",
          "readOnly": true
        },
        "name": {
          "type": "string",
          "maxLength": 50,
          "minLength": 1
        }
      }
    }
  }
}`))
}
