// Concrete handler functions for KPI related operations

package kpis

import (
	log "code.justin.tv/qe/oml-service/logger"
	"github.com/go-openapi/runtime/middleware"

	"code.justin.tv/qe/oml-service/db"
	"code.justin.tv/qe/oml-service/models"
)

// ErrorMessage returns an instance of GetKpisDefault with the specified error code and error message
func ErrorMessage(code int64, message string) *GetKpisDefault {
	return NewGetKpisDefault(500).WithPayload(&models.Error{
		Code:    &code,
		Message: &message,
	})
}

// Kpis returns KPIs that are persisted in the backend
func Kpis(params GetKpisParams) middleware.Responder {
	dbUtil := params.HTTPRequest.Context().Value("dbutil").(*db.DBUtil)
	if dbUtil == nil {
		log.Error("Unable to connect to DB")
		return ErrorMessage(500, "Unable to connect to DB")
	}

	kpis, err := dbUtil.GetKpis()
	if err != nil {
		log.Error(err.Error())
		return ErrorMessage(500, "Error: unable to parse sql row")
	}
	payload := models.GetKpisOKBody(kpis)

	return NewGetKpisOK().WithPayload(payload)
}
