// Code generated by go-swagger; DO NOT EDIT.

package metrics

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"
)

// NewGetMetricsParams creates a new GetMetricsParams object
// with the default values initialized.
func NewGetMetricsParams() GetMetricsParams {
	var ()
	return GetMetricsParams{}
}

// GetMetricsParams contains all the bound params for the get metrics operation
// typically these are obtained from a http.Request
//
// swagger:parameters GetMetrics
type GetMetricsParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Get the metrics for this given date. Date is of YYYY-MM-DD format
	  In: query
	*/
	IngestDate *string
	/*
	  In: query
	*/
	KpiID *int64
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls
func (o *GetMetricsParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error
	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qIngestDate, qhkIngestDate, _ := qs.GetOK("ingest_date")
	if err := o.bindIngestDate(qIngestDate, qhkIngestDate, route.Formats); err != nil {
		res = append(res, err)
	}

	qKpiID, qhkKpiID, _ := qs.GetOK("kpi_id")
	if err := o.bindKpiID(qKpiID, qhkKpiID, route.Formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetMetricsParams) bindIngestDate(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}
	if raw == "" { // empty values pass all other validations
		return nil
	}

	o.IngestDate = &raw

	return nil
}

func (o *GetMetricsParams) bindKpiID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}
	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertInt64(raw)
	if err != nil {
		return errors.InvalidType("kpi_id", "query", "int64", raw)
	}
	o.KpiID = &value

	return nil
}
