// Concrete handler functions for Metrics related operations

package metrics

import (
	log "code.justin.tv/qe/oml-service/logger"
	"github.com/go-openapi/runtime/middleware"

	"code.justin.tv/qe/oml-service/db"
	"code.justin.tv/qe/oml-service/models"
)

// ErrorMessage returns an instance of GetMetricsDefault with the specified error code and error message
func ErrorMessage(code int64, message string) *GetMetricsDefault {
	return NewGetMetricsDefault(500).WithPayload(&models.Error{
		Code:    &code,
		Message: &message,
	})
}

// Metrics returns Metrics that are persisted in the backend (Metrics_Summary table)
func Metrics(params GetMetricsParams) middleware.Responder {
	dbUtil := params.HTTPRequest.Context().Value("dbutil").(*db.DBUtil)
	if dbUtil == nil {
		log.Error("Unable to connect to DB")
		return ErrorMessage(500, "Unable to connect to DB")
	}

	ingestDate, err := dbUtil.GetLatestTimestamp(params.KpiID, params.IngestDate)
	if err != nil {
		return ErrorMessage(500, "could not retrieve max date from db")
	}

	var kpiId = params.KpiID

	metricSummaries, err := dbUtil.GetMetrics(kpiId, ingestDate)
	if err != nil {
		return ErrorMessage(500, "Unable to retrieve Metrics from DB")
	}

	payload := models.GetMetricsOKBody(metricSummaries)

	return NewGetMetricsOK().WithPayload(payload)
}
