// Code generated by go-swagger; DO NOT EDIT.

package metrics_summary

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	strfmt "github.com/go-openapi/strfmt"
)

// NewGetMetricsSummaryParams creates a new GetMetricsSummaryParams object
// with the default values initialized.
func NewGetMetricsSummaryParams() GetMetricsSummaryParams {
	var ()
	return GetMetricsSummaryParams{}
}

// GetMetricsSummaryParams contains all the bound params for the get metrics summary operation
// typically these are obtained from a http.Request
//
// swagger:parameters GetMetricsSummary
type GetMetricsSummaryParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Get the metrics summary for this given date. Date is of YYYY-MM-DD format
	  In: query
	*/
	IngestDate *string
	/*
	  In: query
	*/
	OmlBuID *int64
	/*
	  In: query
	*/
	OmlTeamID *int64
	/*
	  Required: true
	  In: query
	*/
	RollupID int64
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls
func (o *GetMetricsSummaryParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error
	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qIngestDate, qhkIngestDate, _ := qs.GetOK("ingest_date")
	if err := o.bindIngestDate(qIngestDate, qhkIngestDate, route.Formats); err != nil {
		res = append(res, err)
	}

	qOmlBuID, qhkOmlBuID, _ := qs.GetOK("oml_bu_id")
	if err := o.bindOmlBuID(qOmlBuID, qhkOmlBuID, route.Formats); err != nil {
		res = append(res, err)
	}

	qOmlTeamID, qhkOmlTeamID, _ := qs.GetOK("oml_team_id")
	if err := o.bindOmlTeamID(qOmlTeamID, qhkOmlTeamID, route.Formats); err != nil {
		res = append(res, err)
	}

	qRollupID, qhkRollupID, _ := qs.GetOK("rollup_id")
	if err := o.bindRollupID(qRollupID, qhkRollupID, route.Formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetMetricsSummaryParams) bindIngestDate(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}
	if raw == "" { // empty values pass all other validations
		return nil
	}

	o.IngestDate = &raw

	return nil
}

func (o *GetMetricsSummaryParams) bindOmlBuID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}
	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertInt64(raw)
	if err != nil {
		return errors.InvalidType("oml_bu_id", "query", "int64", raw)
	}
	o.OmlBuID = &value

	return nil
}

func (o *GetMetricsSummaryParams) bindOmlTeamID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}
	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertInt64(raw)
	if err != nil {
		return errors.InvalidType("oml_team_id", "query", "int64", raw)
	}
	o.OmlTeamID = &value

	return nil
}

func (o *GetMetricsSummaryParams) bindRollupID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	if !hasKey {
		return errors.Required("rollup_id", "query")
	}
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}
	if err := validate.RequiredString("rollup_id", "query", raw); err != nil {
		return err
	}

	value, err := swag.ConvertInt64(raw)
	if err != nil {
		return errors.InvalidType("rollup_id", "query", "int64", raw)
	}
	o.RollupID = value

	return nil
}
