// Concrete handler functions for Metrics Summary related operations

package metrics_summary

import (
	log "code.justin.tv/qe/oml-service/logger"
	"github.com/go-openapi/runtime/middleware"

	"code.justin.tv/qe/oml-service/db"
	"code.justin.tv/qe/oml-service/models"
)

// ErrorMessage returns an instance of GetMetricsSummaryDefault with the specified error code and error message
func ErrorMessage(code int64, message string) *GetMetricsSummaryDefault {
	return NewGetMetricsSummaryDefault(500).WithPayload(&models.Error{
		Code:    &code,
		Message: &message,
	})
}

// MetricsSummary returns MetricsSummary that are persisted in the backend
func MetricsSummary(params GetMetricsSummaryParams) middleware.Responder {
	dbUtil := params.HTTPRequest.Context().Value("dbutil").(*db.DBUtil)
	if dbUtil == nil {
		log.Error("Unable to connect to DB")
		return ErrorMessage(500, "Unable to connect to DB")
	}

	ingestDate, err := dbUtil.GetLatestTimestamp(nil, params.IngestDate)

	metricSummaries, err := dbUtil.GetMetricsSummary(params.RollupID, ingestDate, params.OmlBuID, params.OmlTeamID)
	if err != nil {
		return ErrorMessage(500, "Unable to retrieve Metric Summaries from DB")
	}

	payload := models.GetMetricsSummaryOKBody(metricSummaries)

	return NewGetMetricsSummaryOK().WithPayload(payload)
}
