// Code generated by go-swagger; DO NOT EDIT.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"net/http"
	"strings"

	errors "github.com/go-openapi/errors"
	loads "github.com/go-openapi/loads"
	runtime "github.com/go-openapi/runtime"
	middleware "github.com/go-openapi/runtime/middleware"
	security "github.com/go-openapi/runtime/security"
	spec "github.com/go-openapi/spec"
	strfmt "github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"code.justin.tv/qe/oml-service/restapi/operations/kpis"
	"code.justin.tv/qe/oml-service/restapi/operations/metrics"
	"code.justin.tv/qe/oml-service/restapi/operations/metrics_summary"
	"code.justin.tv/qe/oml-service/restapi/operations/org"
	"code.justin.tv/qe/oml-service/restapi/operations/practices"
	"code.justin.tv/qe/oml-service/restapi/operations/repos"
	"code.justin.tv/qe/oml-service/restapi/operations/rollups"
)

// NewOMLAPI creates a new OML instance
func NewOMLAPI(spec *loads.Document) *OMLAPI {
	return &OMLAPI{
		handlers:            make(map[string]map[string]http.Handler),
		formats:             strfmt.Default,
		defaultConsumes:     "application/json",
		defaultProduces:     "application/json",
		ServerShutdown:      func() {},
		spec:                spec,
		ServeError:          errors.ServeError,
		BasicAuthenticator:  security.BasicAuth,
		APIKeyAuthenticator: security.APIKeyAuth,
		BearerAuthenticator: security.BearerAuth,
		JSONConsumer:        runtime.JSONConsumer(),
		JSONProducer:        runtime.JSONProducer(),
		GetHandler: GetHandlerFunc(func(params GetParams) middleware.Responder {
			return middleware.NotImplemented("operation Get has not yet been implemented")
		}),
		KpisGetKpisHandler: kpis.GetKpisHandlerFunc(func(params kpis.GetKpisParams) middleware.Responder {
			return middleware.NotImplemented("operation KpisGetKpis has not yet been implemented")
		}),
		MetricsGetMetricsHandler: metrics.GetMetricsHandlerFunc(func(params metrics.GetMetricsParams) middleware.Responder {
			return middleware.NotImplemented("operation MetricsGetMetrics has not yet been implemented")
		}),
		MetricsSummaryGetMetricsSummaryHandler: metrics_summary.GetMetricsSummaryHandlerFunc(func(params metrics_summary.GetMetricsSummaryParams) middleware.Responder {
			return middleware.NotImplemented("operation MetricsSummaryGetMetricsSummary has not yet been implemented")
		}),
		OrgGetOrgHandler: org.GetOrgHandlerFunc(func(params org.GetOrgParams) middleware.Responder {
			return middleware.NotImplemented("operation OrgGetOrg has not yet been implemented")
		}),
		PracticesGetPracticesHandler: practices.GetPracticesHandlerFunc(func(params practices.GetPracticesParams) middleware.Responder {
			return middleware.NotImplemented("operation PracticesGetPractices has not yet been implemented")
		}),
		ReposGetReposHandler: repos.GetReposHandlerFunc(func(params repos.GetReposParams) middleware.Responder {
			return middleware.NotImplemented("operation ReposGetRepos has not yet been implemented")
		}),
		RollupsGetRollupsHandler: rollups.GetRollupsHandlerFunc(func(params rollups.GetRollupsParams) middleware.Responder {
			return middleware.NotImplemented("operation RollupsGetRollups has not yet been implemented")
		}),
	}
}

/*OMLAPI OML service provides RESTful interface to OML data */
type OMLAPI struct {
	spec            *loads.Document
	context         *middleware.Context
	handlers        map[string]map[string]http.Handler
	formats         strfmt.Registry
	defaultConsumes string
	defaultProduces string
	Middleware      func(middleware.Builder) http.Handler

	// BasicAuthenticator generates a runtime.Authenticator from the supplied basic auth function.
	// It has a default implemention in the security package, however you can replace it for your particular usage.
	BasicAuthenticator func(security.UserPassAuthentication) runtime.Authenticator
	// APIKeyAuthenticator generates a runtime.Authenticator from the supplied token auth function.
	// It has a default implemention in the security package, however you can replace it for your particular usage.
	APIKeyAuthenticator func(string, string, security.TokenAuthentication) runtime.Authenticator
	// BearerAuthenticator generates a runtime.Authenticator from the supplied bearer token auth function.
	// It has a default implemention in the security package, however you can replace it for your particular usage.
	BearerAuthenticator func(string, security.ScopedTokenAuthentication) runtime.Authenticator

	// JSONConsumer registers a consumer for a "application/json" mime type
	JSONConsumer runtime.Consumer

	// JSONProducer registers a producer for a "application/tv.twitch.oml.v1+json" mime type
	JSONProducer runtime.Producer

	// GetHandler sets the operation handler for the get operation
	GetHandler GetHandler
	// KpisGetKpisHandler sets the operation handler for the get kpis operation
	KpisGetKpisHandler kpis.GetKpisHandler
	// MetricsGetMetricsHandler sets the operation handler for the get metrics operation
	MetricsGetMetricsHandler metrics.GetMetricsHandler
	// MetricsSummaryGetMetricsSummaryHandler sets the operation handler for the get metrics summary operation
	MetricsSummaryGetMetricsSummaryHandler metrics_summary.GetMetricsSummaryHandler
	// OrgGetOrgHandler sets the operation handler for the get org operation
	OrgGetOrgHandler org.GetOrgHandler
	// PracticesGetPracticesHandler sets the operation handler for the get practices operation
	PracticesGetPracticesHandler practices.GetPracticesHandler
	// ReposGetReposHandler sets the operation handler for the get repos operation
	ReposGetReposHandler repos.GetReposHandler
	// RollupsGetRollupsHandler sets the operation handler for the get rollups operation
	RollupsGetRollupsHandler rollups.GetRollupsHandler

	// ServeError is called when an error is received, there is a default handler
	// but you can set your own with this
	ServeError func(http.ResponseWriter, *http.Request, error)

	// ServerShutdown is called when the HTTP(S) server is shut down and done
	// handling all active connections and does not accept connections any more
	ServerShutdown func()

	// Custom command line argument groups with their descriptions
	CommandLineOptionsGroups []swag.CommandLineOptionsGroup

	// User defined logger function.
	Logger func(string, ...interface{})
}

// SetDefaultProduces sets the default produces media type
func (o *OMLAPI) SetDefaultProduces(mediaType string) {
	o.defaultProduces = mediaType
}

// SetDefaultConsumes returns the default consumes media type
func (o *OMLAPI) SetDefaultConsumes(mediaType string) {
	o.defaultConsumes = mediaType
}

// SetSpec sets a spec that will be served for the clients.
func (o *OMLAPI) SetSpec(spec *loads.Document) {
	o.spec = spec
}

// DefaultProduces returns the default produces media type
func (o *OMLAPI) DefaultProduces() string {
	return o.defaultProduces
}

// DefaultConsumes returns the default consumes media type
func (o *OMLAPI) DefaultConsumes() string {
	return o.defaultConsumes
}

// Formats returns the registered string formats
func (o *OMLAPI) Formats() strfmt.Registry {
	return o.formats
}

// RegisterFormat registers a custom format validator
func (o *OMLAPI) RegisterFormat(name string, format strfmt.Format, validator strfmt.Validator) {
	o.formats.Add(name, format, validator)
}

// Validate validates the registrations in the OMLAPI
func (o *OMLAPI) Validate() error {
	var unregistered []string

	if o.JSONConsumer == nil {
		unregistered = append(unregistered, "JSONConsumer")
	}

	if o.JSONProducer == nil {
		unregistered = append(unregistered, "JSONProducer")
	}

	if o.GetHandler == nil {
		unregistered = append(unregistered, "GetHandler")
	}

	if o.KpisGetKpisHandler == nil {
		unregistered = append(unregistered, "kpis.GetKpisHandler")
	}

	if o.MetricsGetMetricsHandler == nil {
		unregistered = append(unregistered, "metrics.GetMetricsHandler")
	}

	if o.MetricsSummaryGetMetricsSummaryHandler == nil {
		unregistered = append(unregistered, "metrics_summary.GetMetricsSummaryHandler")
	}

	if o.OrgGetOrgHandler == nil {
		unregistered = append(unregistered, "org.GetOrgHandler")
	}

	if o.PracticesGetPracticesHandler == nil {
		unregistered = append(unregistered, "practices.GetPracticesHandler")
	}

	if o.ReposGetReposHandler == nil {
		unregistered = append(unregistered, "repos.GetReposHandler")
	}

	if o.RollupsGetRollupsHandler == nil {
		unregistered = append(unregistered, "rollups.GetRollupsHandler")
	}

	if len(unregistered) > 0 {
		return fmt.Errorf("missing registration: %s", strings.Join(unregistered, ", "))
	}

	return nil
}

// ServeErrorFor gets a error handler for a given operation id
func (o *OMLAPI) ServeErrorFor(operationID string) func(http.ResponseWriter, *http.Request, error) {
	return o.ServeError
}

// AuthenticatorsFor gets the authenticators for the specified security schemes
func (o *OMLAPI) AuthenticatorsFor(schemes map[string]spec.SecurityScheme) map[string]runtime.Authenticator {

	return nil

}

// Authorizer returns the registered authorizer
func (o *OMLAPI) Authorizer() runtime.Authorizer {

	return nil

}

// ConsumersFor gets the consumers for the specified media types
func (o *OMLAPI) ConsumersFor(mediaTypes []string) map[string]runtime.Consumer {

	result := make(map[string]runtime.Consumer)
	for _, mt := range mediaTypes {
		switch mt {

		case "application/json":
			result["application/json"] = o.JSONConsumer

		case "application/tv.twitch.oml.v1+json":
			result["application/tv.twitch.oml.v1+json"] = o.JSONConsumer

		}
	}
	return result

}

// ProducersFor gets the producers for the specified media types
func (o *OMLAPI) ProducersFor(mediaTypes []string) map[string]runtime.Producer {

	result := make(map[string]runtime.Producer)
	for _, mt := range mediaTypes {
		switch mt {

		case "application/json":
			result["application/json"] = o.JSONProducer

		case "application/tv.twitch.oml.v1+json":
			result["application/tv.twitch.oml.v1+json"] = o.JSONProducer

		}
	}
	return result

}

// HandlerFor gets a http.Handler for the provided operation method and path
func (o *OMLAPI) HandlerFor(method, path string) (http.Handler, bool) {
	if o.handlers == nil {
		return nil, false
	}
	um := strings.ToUpper(method)
	if _, ok := o.handlers[um]; !ok {
		return nil, false
	}
	if path == "/" {
		path = ""
	}
	h, ok := o.handlers[um][path]
	return h, ok
}

// Context returns the middleware context for the o m l API
func (o *OMLAPI) Context() *middleware.Context {
	if o.context == nil {
		o.context = middleware.NewRoutableContext(o.spec, o, nil)
	}

	return o.context
}

func (o *OMLAPI) initHandlerCache() {
	o.Context() // don't care about the result, just that the initialization happened

	if o.handlers == nil {
		o.handlers = make(map[string]map[string]http.Handler)
	}

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"][""] = NewGet(o.context, o.GetHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/kpis"] = kpis.NewGetKpis(o.context, o.KpisGetKpisHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/metrics"] = metrics.NewGetMetrics(o.context, o.MetricsGetMetricsHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/metrics_summary"] = metrics_summary.NewGetMetricsSummary(o.context, o.MetricsSummaryGetMetricsSummaryHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/org"] = org.NewGetOrg(o.context, o.OrgGetOrgHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/practices"] = practices.NewGetPractices(o.context, o.PracticesGetPracticesHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/repos"] = repos.NewGetRepos(o.context, o.ReposGetReposHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/rollups"] = rollups.NewGetRollups(o.context, o.RollupsGetRollupsHandler)

}

// Serve creates a http handler to serve the API over HTTP
// can be used directly in http.ListenAndServe(":8000", api.Serve(nil))
func (o *OMLAPI) Serve(builder middleware.Builder) http.Handler {
	o.Init()

	if o.Middleware != nil {
		return o.Middleware(builder)
	}
	return o.context.APIHandler(builder)
}

// Init allows you to just initialize the handler cache, you can then recompose the middelware as you see fit
func (o *OMLAPI) Init() {
	if len(o.handlers) == 0 {
		o.initHandlerCache()
	}
}
