package org

// Concrete handler functions for Org related operations

import (
	"github.com/go-openapi/runtime/middleware"
	log "code.justin.tv/qe/oml-service/logger"

	"code.justin.tv/qe/oml-service/models"
	"code.justin.tv/qe/oml-service/db"
)

// ErrorMessage returns an instance of GetOrgDefault with the specified error code and error message
func ErrorMessage(code int64, message string) *GetOrgDefault {
	return NewGetOrgDefault(500).WithPayload(&models.Error{
		Code: &code,
		Message: &message,
	})
}

// Org returns org related information persisted in the backend
func Org(params GetOrgParams) middleware.Responder {
	dbUtil := params.HTTPRequest.Context().Value("dbutil").(*db.DBUtil)
	if dbUtil == nil {
		log.Error("Unable to connect to DB")
		return ErrorMessage(500, "Unable to connect to DB")
	}

	orgs, err := dbUtil.GetOrg(params.OmlBuID, params.OmlTeamID)
	if err != nil {
		return ErrorMessage(500, err.Error())
	}
	payload := models.GetOrgOKBody(orgs)

	return NewGetOrgOK().WithPayload(payload)
}