package practices

import (
	"github.com/go-openapi/runtime/middleware"
	log "code.justin.tv/qe/oml-service/logger"

	"code.justin.tv/qe/oml-service/models"
	"code.justin.tv/qe/oml-service/db"
)


// ErrorMessage returns an instance of GetPracticesDefault with the specified error code and error message
func ErrorMessage(code int64, message string) *GetPracticesDefault {
	return NewGetPracticesDefault(500).WithPayload(&models.Error{
		Code: &code,
		Message: &message,
	})
}

func Practices(params GetPracticesParams) middleware.Responder {
	dbUtil := params.HTTPRequest.Context().Value("dbutil").(*db.DBUtil)
	if dbUtil == nil {
		log.Error("Unable to connect to DB")
		return ErrorMessage(500, "Unable to connect to DB")
	}
	practices, err := dbUtil.GetPractices()
	if err != nil {
	    return ErrorMessage(500, err.Error())
    }
    payload := models.GetPracticesOKBody(practices)

	return NewGetPracticesOK().WithPayload(payload)
}

