package rollups

import (
	log "code.justin.tv/qe/oml-service/logger"
	"github.com/go-openapi/runtime/middleware"

	"code.justin.tv/qe/oml-service/db"
	"code.justin.tv/qe/oml-service/models"
)

// ErrorMessage returns an instance of GetOrgDefault with the specified error code and error message
func ErrorMessage(code int64, message string) *GetRollupsDefault {
	return NewGetRollupsDefault(500).WithPayload(&models.Error{
		Code:    &code,
		Message: &message,
	})
}

func Rollups(params GetRollupsParams) middleware.Responder {
	dbUtil := params.HTTPRequest.Context().Value("dbutil").(*db.DBUtil)
	if dbUtil == nil {
		log.Error("Unable to connect to DB")
		return ErrorMessage(500, "Unable to connect to DB")
	}
	rollups, err := dbUtil.GetRollups()
	if err != nil {
		return ErrorMessage(500, err.Error())
	}

	payload := models.GetRollupsOKBody(rollups)

	return NewGetRollupsOK().WithPayload(payload)
}
