variable "metric_name" {}
variable "sns_arn" {}
variable "threshold" {}

// Reference: https://www.terraform.io/docs/providers/aws/r/cloudwatch_metric_alarm.html
resource "aws_cloudwatch_metric_alarm" "beanstalk_alarm"{
  // meta-data
  alarm_name                = "qe-oml-service-${var.metric_name}-alarm"
  alarm_description         = "This metric monitors ${var.metric_name}"

  // filter the metrics into this alarm
  namespace                 = "AWS/ElasticBeanstalk"
  metric_name               = "${var.metric_name}"
  dimensions {
    EnvironmentName = "staging-qe-oml-service-env"  // For now, Staging is the main environment
  }

  // setup the thresholds for the metric
  statistic                 = "Average"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  threshold                 = "${var.threshold}"
  period                    = "300" // 5 minutes
  evaluation_periods        = "1"

  // action - notify the SNS topic that's configured for pagerduty
  alarm_actions             = ["${var.sns_arn}"]
}