

module "bs-canary" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-cape-qe-aws"
  aws_region = "us-west-2"
  eb_application_name = "${module.bs-app-twitch-cape-qe-aws.beanstalk_application_name}"
  vpc_id = "vpc-25d89842"
  ec2_subnet_ids = "subnet-cf9a03a8,subnet-b3b102fa,subnet-c83d2990"
  elb_subnet_ids = "subnet-cf9a03a8,subnet-b3b102fa,subnet-c83d2990"
  elb_loadbalancer_security_groups = "sg-09687471"
  auto_scaling_lc_security_groups = "sg-09687471"
  solution_stack_name = "64bit Amazon Linux 2017.09 v2.8.0 running Docker 17.06.2-ce"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "qe-team@twitch.tv"
  service = "qe/oml-service"
  env = "canary"
  associate_public_address = "false"
  cname_prefix = "oml-api-canary"

}
