module "oml_service_health_alarm" {
  source = "../modules/oml_beanstalk_alarm"
  metric_name = "EnvironmentHealth"
  threshold = "0"  // 0=OK. See https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aeb-metricscollected.html
  sns_arn = "${aws_sns_topic.qe_oml_service_pagerduty.arn}"
}

module "oml_service_latency_alarm" {
  source = "../modules/oml_beanstalk_alarm"
  metric_name = "ApplicationLatencyP90"
  threshold = "0.3"  // 300ms latency
  sns_arn = "${aws_sns_topic.qe_oml_service_pagerduty.arn}"
}

module "oml_service_http5xx_alarm" {
  source = "../modules/oml_beanstalk_alarm"
  metric_name = "ApplicationRequests5xx"
  threshold = "0"
  sns_arn = "${aws_sns_topic.qe_oml_service_pagerduty.arn}"
}