# OML Tool

## Project Structure
```
config/
  org.json : mapping org/team/service(if any) between various data sources
  jira_queries.json : jira queries. Key names should be explictly clear and match exactly with
                      https://docs.google.com/document/d/1BLEG0Yk7go0i3diUM44FKgwVb5mXg6Vd7afoCKagOug/edit#

oml/
  datasource.py : data source classes (jira, internal status, etc)
  handlers.py : invokes data source classes with specified inputs and returns presentation-agnostic outputs
  orghelper.py : helper class to navigate between org info (based on org.json)
  presentation.py : presentation layer for future use

bin/
  oml.py: command-line interface takes in input from user and runs appropriate handlers

tests/
  test_*.py : various tests

./
  setup.py : python build script
  requirements.txt : dependencies list
```
## Running CLI

Steps:

 1. Make sure python3.6 is installed
 2. Copy jira_token.auth and privkey.pem into top level directory (where README.md is)
 3. export PYTHONPATH=$PYTHONPATH:$PWD/oml
 4. pip3.6 install -r requirements.txt
 5. run oml.py, eg: python bin/oml.py ri --rollup team --bu "CAPE" --team "*"

## Running Tests

Steps:

 1. Make sure python3.6 is installed
 2. Copy jira_token.auth and privkey.pem into top level directory (where README.md is)
 3. export PYTHONPATH=$PYTHONPATH:$PWD/oml
 4. pip3.6 install -r requirements.txt
 5. python -m unittest tests/test_oml.py

## Generate Documentation

pydoc3.6 oml/*py

## Build

python3.6 ./setup.py build

