"""add new canary time series

Revision ID: 40b2e39d3ebc
Revises: 1485fa1f7f70
Create Date: 2017-11-07 11:57:03.039300

"""
import traceback

import sys
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '40b2e39d3ebc'
down_revision = '1485fa1f7f70'
branch_labels = None
depends_on = None


def upgrade():
    try:
        conn = op.get_bind()
        conn.execute("INSERT INTO TIME_SERIES_DEF(`KEY`, NAME) VALUES('DEPLOY-CAN', 'Deployments - Canary')")
        conn.execute("INSERT INTO TIME_SERIES_DEF(`KEY`, NAME) VALUES('DEPLOY-ALL', 'Deployments - All')")

    except Exception as e:
        print("ERROR: DB Migration failed due to the error below. Perform a downgrade immediately and fix the issue!")
        traceback.print_exc(file=sys.stdout)


def downgrade():
    try:
        conn = op.get_bind()
        conn.execute("DELETE FROM TIME_SERIES_DEF WHERE `KEY`='DEPLOY-CAN'")
        conn.execute("DELETE FROM TIME_SERIES_DEF WHERE `KEY`='DEPLOY-ALL'")

    except Exception as e:
        print("ERROR: DB Migration failed due to the error below. Perform a downgrade immediately and fix the issue!")
        traceback.print_exc(file=sys.stdout)