"""add new time series for unit test metrics

Revision ID: f4b22a9cd4af
Revises: 40b2e39d3ebc
Create Date: 2017-11-15 17:21:38.552267

"""
import traceback

import sys
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'f4b22a9cd4af'
down_revision = '40b2e39d3ebc'
branch_labels = None
depends_on = None


def upgrade():
    try:
        conn = op.get_bind()
        conn.execute("INSERT INTO TIME_SERIES_DEF(`KEY`, NAME) VALUES('BUILD-UT', 'Builds - Unit Tested')")
        conn.execute("INSERT INTO TIME_SERIES_DEF(`KEY`, NAME) VALUES('BUILD-ALL', 'Builds - Build+Unit Tested')")

    except Exception as e:
        print("ERROR: DB Migration failed due to the error below. Perform a downgrade immediately and fix the issue!")
        traceback.print_exc(file=sys.stdout)


def downgrade():
    try:
        conn = op.get_bind()
        conn.execute("DELETE FROM TIME_SERIES_DEF WHERE `KEY`='BUILD-UT'")
        conn.execute("DELETE FROM TIME_SERIES_DEF WHERE `KEY`='BUILD-ALL'")

    except Exception as e:
        print("ERROR: DB Migration failed due to the error below. Perform a downgrade immediately and fix the issue!")
        traceback.print_exc(file=sys.stdout)
