job {
  name('qe-oml-build')
  using('TEMPLATE-autobuild')

  wrappers {
    credentialsBinding {
      file('CODECOV_ACCESS_TOKEN_FILE', 'twitch-qe-codecov-access-token')
      file('MYSQL_CRED_TOKEN_FILE', 'twitch-qe-mysql-dev-oml-creds')
      file('GITHUB_ACCESS_TOKEN_FILE', 'twitch-qe-github-access-token')
      file('JIRA_PRIVKEY_FILE', 'twitch-qe-jira-privkey-pem')
      file('JIRA_AUTH_TOKEN_FILE', 'twitch-qe-jira-auth-token')
      file('AWS_CONFIG_FILE', 'twitch-cape-qe-aws-profile')
      file('AWS_UPLOADER_CONFIG_FILE', 'twitch-cape-qe-aws-profile')
    }
  }

  scm {
    git {
      remote {
        github('qe/oml', 'ssh', 'git-aws.internal.justin.tv')
        credentials('git-aws-read-key')
      }
    }
  }

  steps {
    // Copy the secrets files from Jenkin's store dir to workspace dir so that they are available in manta
    shell('cp $CODECOV_ACCESS_TOKEN_FILE secrets-twitch-qe-codecov-access-token')
    shell('cp $MYSQL_CRED_TOKEN_FILE secrets-twitch-qe-mysql-dev-oml-creds')
    shell('cp $GITHUB_ACCESS_TOKEN_FILE secrets-twitch-qe-github-access-token')
    shell('cp $JIRA_PRIVKEY_FILE privkey.pem')
    shell('cp $JIRA_AUTH_TOKEN_FILE jira_token.auth')

    // Clean and execute build
    shell('rm -rf .manta/')
    shell('manta -v -proxy -f build.json')

    // Post code-coverage
    reportCodeCoverage("qe/oml", "oml", ".manta/coverage.xml")

    saveLambdaFunction("qe/oml", ".manta/lambda", "oml-private", "default")
  }

  publishers {
    archiveJunit('.manta/nosetests.xml')
    reportQuality('qe/oml', '.manta')
    downstream('qe-oml-db-update-staging')
  }
}

job {
  name('qe-oml-db-update-staging')
  using('TEMPLATE-autobuild')

  wrappers {
    credentialsBinding {
      file('MYSQL_CRED_TOKEN_FILE', 'twitch-qe-mysql-staging-oml-creds')
    }
  }

  scm {
    git {
      remote {
        github('qe/oml', 'ssh', 'git-aws.internal.justin.tv')
        credentials('git-aws-read-key')
      }
    }
  }

  steps {
    // Copy the secrets files from Jenkin's store dir to workspace dir so that they are available in manta
    shell('cp $MYSQL_CRED_TOKEN_FILE secrets-twitch-qe-mysql-staging-oml-creds')

    // Clean and execute build
    shell('rm -rf .manta/')
    shell('manta -v -proxy -f db-update-staging.json')
  }
}

job {
  name('qe-oml-default-deploy')
  using('TEMPLATE-lambda-deploy')

  // TEMPLATE-lambda-deploy injects ENVIRONMENT and GIT_COMMIT parameters

  wrappers {
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cape-qe-aws-profile')
      file('AWS_UPLOADER_CONFIG_FILE', 'twitch-cape-qe-aws-profile')
    }
  }

  steps {
    deployLambdaFunction("qe/oml", "oml_ingest_availability-\$ENVIRONMENT", "\$ENVIRONMENT", "oml-private", "default")
    deployLambdaFunction("qe/oml", "oml_ingest_ri-\$ENVIRONMENT", "\$ENVIRONMENT", "oml-private", "default")
    deployLambdaFunction("qe/oml", "oml_ingest_bugs-\$ENVIRONMENT", "\$ENVIRONMENT", "oml-private", "default")
    deployLambdaFunction("qe/oml", "oml_ingest_codecov-\$ENVIRONMENT", "\$ENVIRONMENT", "oml-private", "default")
    deployLambdaFunction("qe/oml", "oml_ingest_autoenv-\$ENVIRONMENT", "\$ENVIRONMENT", "oml-private", "default")
    deployLambdaFunction("qe/oml", "oml_ingest_integtest-\$ENVIRONMENT", "\$ENVIRONMENT", "oml-private", "default")
    deployLambdaFunction("qe/oml", "oml_ingest_unittest-\$ENVIRONMENT", "\$ENVIRONMENT", "oml-private", "default")
    deployLambdaFunction("qe/oml", "oml_ingest_canaries-\$ENVIRONMENT", "\$ENVIRONMENT", "oml-private", "default")
    deployLambdaFunction("qe/oml", "oml_ingest_configmgmt-\$ENVIRONMENT", "\$ENVIRONMENT", "oml-private", "default")
    deployLambdaFunction("qe/oml", "oml_ingest_alerts-\$ENVIRONMENT", "\$ENVIRONMENT", "oml-private", "default")
  }
}
