import functools

from twitch import sandstorm

SANDSTORM_ROLE = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/qe-oml-staging"


class SandStormHelper(object):
    @staticmethod
    @functools.lru_cache()
    def get_sandstorm():
        return sandstorm.SandstormClient(SANDSTORM_ROLE)

    @staticmethod
    @functools.lru_cache()
    def get_secrets(name):
        return SandStormHelper.get_sandstorm().GetSecret(name)

    @staticmethod
    @functools.lru_cache()
    def get_secrets_str(name):
        return SandStormHelper.get_secrets(name).decode('utf-8')