variable "environment" {} # IMPORTANT: Set with export TF_VAR_environment=... or enter when prompted by terraform

variable "metric" {}

variable "lambda_runtime" {
  default = "python3.6"
}

variable "principal" {
  default = "arn:aws:iam::425992774280:root"
}

variable "owner" {
  default = "qe-team"
}

variable "repo" {
  default = "qe/oml"
}

variable "bucket" {
  default = "oml-private"
}

module "oml_cron_lambda" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_lambda_app.git?ref=1.6.0"
  owner = "${var.owner}"
  repository = "${var.repo}"
  environment = "${var.environment}"
  principal = "${var.principal}"
  lambda_runtime = "${var.lambda_runtime}"
  aws_profile = "${var.oml_aws_profile}"
  aws_region = "${var.oml_aws_region}"
  lambda_vpc_subnet_ids = "${data.terraform_remote_state.parent_account_vpc.private_a},${data.terraform_remote_state.parent_account_vpc.private_b},${data.terraform_remote_state.parent_account_vpc.private_c}"
  lambda_vpc_security_group_ids = "${data.terraform_remote_state.parent_account_vpc.twitch_subnets_sg}"
  lambda_s3_bucket = "${var.bucket}"
  lambda_policy = "${file("files/lambda_policy.json")}"

  lambda_handler = "oml_lambda.lambda_handler_${var.metric}"
  lambda_function_name = "oml_ingest_${var.metric}-${var.environment}"
  lambda_description = "Ingests data, normalizes, and generates summary data: ${var.metric}"
  lambda_timeout = "300"
  lambda_memory_size = 256
}

resource "aws_cloudwatch_event_rule" "run_daily" {
  name = "run_daily_${var.metric}_${var.environment}"
  schedule_expression = "cron(0 8 * * ? *)"
}

resource "aws_cloudwatch_event_target" "lambda_event_target" {
  rule = "${aws_cloudwatch_event_rule.run_daily.name}"
  arn = "${module.oml_cron_lambda.arn}"
}

resource "aws_lambda_permission" "allow_cloudwatch_oml_ingest" {
  statement_id = "AllowExecutionFromCloudWatch_${var.metric}-${var.environment}"
  action = "lambda:InvokeFunction"
  function_name = "oml_ingest_${var.metric}-${var.environment}"
  principal = "events.amazonaws.com"
  source_arn = "${aws_cloudwatch_event_rule.run_daily.arn}"
}
