// Common variables and data go in here

variable "oml_aws_profile" {
  default = "twitch-cape-qe-aws"
}

variable "oml_aws_region" {
  default = "us-west-2"
}

variable "qe_tf_state_bucket_name" {
  default = "tf-state-qe"
}

variable "environments" {
  description = "Environments"
  type = "list"
  default = ["staging", "canary", "production"]
}

variable "metrics" {
  description = "OML Metrics shortnames"
  type = "list"
  default = ["availability", "ri", "bugs", "codecov", "autoenv", "integtest", "unittest", "canaries", "configmgmt", "alerts"]
}

// Reference: https://git-aws.internal.justin.tv/qe/terraform/blob/master/accounts/twitch-cape-qe/vpc/main.tf

// Used for gathering Internal CIDRs
data "terraform_remote_state" "parent_account_sgs" {
  backend = "s3"
  config {
    profile = "${var.oml_aws_profile}"
    bucket = "${var.qe_tf_state_bucket_name}"
    key    = "tfstate/qe/terraform/security-groups"
    region = "${var.oml_aws_region}"
  }
}

data "terraform_remote_state" "parent_account_vpc" {
  backend = "s3"
  config {
    profile = "${var.oml_aws_profile}"
    bucket = "${var.qe_tf_state_bucket_name}"
    key    = "tfstate/qe/terraform/vpc"
    region = "${var.oml_aws_region}"
  }
}