variable "function_name" {}
variable "sns_arn" {}

// Reference: https://www.terraform.io/docs/providers/aws/r/cloudwatch_metric_alarm.html
resource "aws_cloudwatch_metric_alarm" "lambda_invocation_error_alarm"{
  // meta-data
  alarm_name                = "qe-oml-lambda-${var.function_name}-invocation-errors"
  alarm_description         = "This metric monitors lambda function ${var.function_name} invocation errors"

  // filter the metrics into this alarm
  namespace                 = "AWS/Lambda"
  metric_name               = "Errors"
  dimensions {
    FunctionName = "${var.function_name}"
  }

  // setup the thresholds for the metric
  statistic                 = "Sum"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  threshold                 = "0"  // any invocation error should trigger alert
  period                    = "600" // 10 minutes
  evaluation_periods        = "1"

  // action - notify the SNS topic that's configured for pagerduty
  alarm_actions             = ["${var.sns_arn}"]
}