// Reference: https://github.com/datawire/tf-sns-pagerduty/blob/master/main.tf
resource "aws_sns_topic" "qe_oml_pagerduty" {
  name = "qe-oml-pagerduty"
  display_name = "qe-oml-pagerduty"
}

resource "aws_sns_topic_subscription" "pagerduty" {
  // Reference: https://twitchoncall.pagerduty.com/services/PXG23TY/integrations/PX2NXE4
  endpoint = "https://events.pagerduty.com/integration/28fc160f57ca4d238d50c6d9325575f1/enqueue"
  endpoint_auto_confirms = true
  protocol = "https"
  topic_arn = "${aws_sns_topic.qe_oml_pagerduty.arn}"
}