import os
import sys
import unittest

sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

from bin import oml
from datasource import OMLJira, OMLInternalStatus, OMLCodeCov, OMLCapacity, OMLRPS, OMLSkadi, OMLGraphite
from orghelper import OrgHelper


class TestJira(unittest.TestCase):
    """
    Note that the first ever test to run will take in the order of seconds, BUT subsequent tests will complete
    in milliseconds (under 1 second) due to caching
    """

    def test_ri_rollup_bu(self):
        created, resolved = OMLJira().get_percent_RIs_resolved_in_timely_manner("bu", "Platforms and Services", "*")
        assert created > 0
        assert resolved > 0

    def test_ri_rollup_team(self):
        created, resolved = OMLJira().get_percent_RIs_resolved_in_timely_manner("team", "Platforms and Services", "Availability")
        assert created > 0
        assert resolved > 0


class TestAvailability(unittest.TestCase):
    def test_rollup_bu(self):
        report_start_date, data = OMLInternalStatus().get_services_operate_within_an_availability_SLA("bu",
                                                                                                      "BU_BROADCASTER",
                                                                                                      "*")
        assert report_start_date is not None
        assert len(data) > 0

    def test_rollup_team(self):
        report_start_date, data = OMLInternalStatus().get_services_operate_within_an_availability_SLA("team",
                                                                                                      "BU_CAPE",
                                                                                                      "*")
        assert report_start_date is not None
        assert len(data) > 0

    def test_sev123_rollup_bu(self):
        created, resolved = OMLJira().get_percent_sev123_prod_bugs_resolved_in_timely_manner("bu",
                                                                                             "Platforms and Services", "*")
        assert created > 0
        assert resolved > 0

    def test_sev123_rollup_team(self):
        created, resolved = OMLJira().get_percent_sev123_prod_bugs_resolved_in_timely_manner("team", "Developer & Commerce",
                                                                                             "Identity Platform")
        assert created > 0
        assert resolved > 0

    def test_sev123_rollup_team_made_of_multiple_projects(self):
        created, resolved = OMLJira().get_percent_sev123_prod_bugs_resolved_in_timely_manner("team", "Platforms and Services",
                                                                                             ["Core Video Playback",
                                                                                              "Video Ingest"])
        assert created > 0
        assert resolved > 0


class TestIncidents(unittest.TestCase):
    def test_rollup_twitch(self):
        incidents = OMLJira().get_incidents("twitch", None)
        assert len(incidents) > 0


class TestOrgHelper(unittest.TestCase):
    def test_bu_set(self):
        BUs = OrgHelper.ref_BUs()
        assert len(BUs) > 0

    def test_jira_bu(self):
        jbu = OrgHelper.jira_BU('CAPE')
        assert len(jbu) > 0

    def test_jira_bu_negative(self):
        jbu = OrgHelper.jira_BU('NON-EXISTING')
        assert jbu is None

    def test_jira_teams_in_ref_BU(self):
        jp = OrgHelper.jira_teams_in_ref_BU('CAPE')
        assert len(jp) > 0

    def test_jira_to_ref(self):
        result = OrgHelper.jira_to_ref('Browser')
        assert len(result) > 0

    def test_jira_bu_to_ref_bu(self):
        result = OrgHelper.jira_bu_to_ref_bu('CAPE')
        assert len(result) > 0


class TestOMLCodeCov(unittest.TestCase):
    def test_get_repo_codecoverage(self):
        result = OMLCodeCov().get_repo_codecov("twilight/twilight")
        assert len(result) > 0


class TestOMLCapacity(unittest.TestCase):
    def test_get_config_management_status(self):
        result = OMLCapacity().get_config_management_status_summary("bu")
        assert len(result) > 0


# RPS is too unrealiable to run this in CI
# class TestOMLRPS(unittest.TestCase):
#     def test_get_repos_with_test_results(self):
#         result = OMLRPS().get_repos_with_test_results()
#         assert len(result) > 0


class TestOMLSkadi(unittest.TestCase):
    def test_get_environments(self):
        result = OMLSkadi().get_environments()
        assert len(result) > 0

    def test_get_environments_canary(self):
        result = OMLSkadi().get_environments("canary")
        assert len(result) > 0


class TestOMLGraphite(unittest.TestCase):
    def test_get_datapoints(self):
        results = OMLGraphite().get_datapoints("stats.timers.deploys.deployment.web.web.*.start.count", 7)
        assert len(results) > 0


class TestOML(unittest.TestCase):
    def test_output_summary_twitch(self):
        from collections import namedtuple
        Data = namedtuple('Data', ['rollup', "bu", "date", "output"])
        args = Data("twitch", None, None, "plain")
        oml.output_summary(args)  # should not raise any exception

    def test_output_summary_BU(self):
        from collections import namedtuple
        Data = namedtuple('Data', ['rollup', "bu", "output"])
        args = Data("bu", "Community", "plain")
        oml.output_summary(args)  # should not raise any exception

# class TestRandomThings(unittest.TestCase):
#     def test_random_things(self):
#         # https://stackoverflow.com/questions/3204245/how-do-i-convert-a-tuple-of-tuples-to-a-one-dimensional-list-using-list-comprehe
#         #bu_ids = sum(DBHelper.run_query("SELECT ID FROM OML_BU"), ())
#         #generate_summary_ratio_of_count_of_within_sla_entries_in_series('2017-10-11 20:42:55', 7, 8,1 )
#         #generate_summary_ratio_of_true_vs_non_true_entries_in_single_series('2017-10-12 11:12:54', 14, 3)
#         #print(bu_ids)
#         pass
