provider "aws" {
    region	= "us-west-2"
    profile 	= "twitch-cape-qe-aws"
}

# References:
# 1) https://git-aws.internal.justin.tv/qe/terraform/blob/master/accounts/twitch-cape-qe/security-groups/main.tf
# 2) https://wiki.twitch.com/display/~davidhsu/list+of+IPs+for+twitch+subnets
# 3) https://wiki.twitch.com/display/NET/Global+Assignments
variable twitch_subnets {
  default = "10.0.0.0/8,192.16.64.0/21,199.9.248.0/21,185.42.204.0/22,127.0.0.1/32,38.99.10.97/32,192.168.0.0/17,45.113.128.0/22,103.53.48.0/22,192.108.239.0/24,23.160.0.0/24,52.223.192.0/18,38.104.129.210/32,38.99.10.96/29,10.255.244.0/22,64.208.156.166/32,72.21.196.68/32,192.168.0.0/17,192.168.128.0/21,192.168.144.0/21,192.168.240.0/21,10.255.252.0/23,10.255.254.0/23,10.255.248.0/23,10.255.250.0/23,69.85.223.168/29,98.173.4.128/27,12.245.210.116/30"
}
# Create an S3 bucket with access restricted to Twitch network. Access is restricted through:
# 1) acl="private" (the default, but explicitly set here for emphasis for human maintainers), AND,
# 2) s3 policy (see below)
resource "aws_s3_bucket" "qml_private_static_bucket" {
  bucket = "qml-private-static"
  acl = "private"

  tags {
    Name = "qml-private-static"
    Owner = "lukemng"
  }
}

# References:
# 1) https://www.terraform.io/docs/providers/aws/r/s3_bucket_policy.html
# 2) https://www.terraform.io/docs/providers/aws/d/iam_policy_document.html#condition
# 3) https://pete.wtf/2012/05/01/how-to-setup-aws-s3-access-from-specific-ips/  (This is the winner)
data "aws_iam_policy_document" "qml_static_bucket" {
    statement {
        actions = ["s3:*"]
        effect = "Deny"
        resources = ["${aws_s3_bucket.qml_private_static_bucket.arn}/*"]
        principals {
          identifiers = ["*"]
          type = "AWS"
        }
        condition = {
            test = "NotIpAddress"
            variable = "aws:SourceIp"
            values = ["${split(",", var.twitch_subnets)}"]
        }
    }
}

resource "aws_s3_bucket_policy" "qml_static_bucket" {
  bucket = "${aws_s3_bucket.qml_private_static_bucket.id}"
  policy = "${data.aws_iam_policy_document.qml_static_bucket.json}"
}

output "qml_arn" {
    value = "${aws_s3_bucket.qml_private_static_bucket.arn}"
}

# NOTE: Objects uploaded into this bucket must be made "public" explicitly when ready to go "live" within Twitch
# Access will be restricted via #1 and #2)
