

module "bs-production-qml" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-cape-qe-aws"
  aws_region = "us-west-2"
  eb_application_name = "${module.bs-app-production.beanstalk_application_name}"
  vpc_id = "vpc-06c9636f"
  ec2_subnet_ids = "subnet-0930d644,subnet-e5f44e8c,subnet-6ef03c15"
  elb_subnet_ids = "subnet-0930d644,subnet-e5f44e8c,subnet-6ef03c15"
  elb_loadbalancer_security_groups = "sg-5a881a20"
  auto_scaling_lc_security_groups = "sg-5a881a20"
  solution_stack_name = "64bit Amazon Linux 2017.03 v2.7.1 running Docker 17.03.1-ce"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "lukemng@justin.tv"
  service = "qe/qml"
  env = "production-qml"
  associate_public_address = "false"

}
