"use strict";
const Page = require('uitf').basePage;

const VIDEO_CONTAINER = '#videoContainer';
const SIGN_UP_BUTTON = '[data-a-target=signup-button].tw-button .tw-button__text';
const PLAYER_PAGE_URL = 'http://cvp-web.twitch.tv/';
const player = '.player';
const gear_button_css = '.qa-settings-button';
const advanced_menu_css = '.qa-advanced-button';
const stats_toggle_css = '.qa-show-stats-button';


class PlayerPage extends Page {
  constructor() {
    super();
  }
    //elements
    get signupButtonElement() { return browser.element(SIGN_UP_BUTTON); }
    get videoContainer()      { return browser.element(VIDEO_CONTAINER)}

    openPlayerPage(){
        console.log(PLAYER_PAGE_URL);
        this.visit(PLAYER_PAGE_URL)
    }

    getSignupButtonText() {
      return this.signupButtonElement.getText();
    }

    waitForVideoContainer() {
      this.videoContainer.waitForExist(50000);
    }

    streamStarted(streamUrl) {
        browser.timeouts('script', 30000);
        let result = browser.executeAsync(function(streamUrl, done) {
            player.setAdInsertionEnabled(false);
            player.addEventListener(PlayerState.PLAYING, function() { done(true)});
            player.load(streamUrl);
            player.play();
        }, streamUrl);
        return result.value;
    }

    getQuality(){
      return browser.execute('return player.getQuality();').value;
    }

    getCurrentQualityName() {
      return this.getQuality()['name']
    }

    setQuality(quality) {
      browser.timeouts('script', 30000);
      if(quality === this.getCurrentQualityName()){
        return true;
      } else {
          let result = browser.executeAsync(function(quality, done) {
              player.addEventListener(PlayerEvent.QUALITY_CHANGED, function (quality) {
                  done(quality['quality']['name'])
              });
              let all_qualities = player.getQualities();
              console.log(player.getQuality())
              for (let qual in all_qualities) {
                  if (all_qualities[qual]['name'].indexOf(quality) !== -1)
                      player.setQuality(all_qualities[qual])
              }
          }, quality);
          return result.value;
      }
    }

    isAbsQualityChange() {
        try {
            console.log("******* Setting the quality as abs*********");
            browser.timeouts('script', 30000);
            let result = browser.executeAsync(function (dummyparam, done) {
                player.addEventListener(PlayerEvent.QUALITY_CHANGED, function () {
                    done(true)
                });
                player.setAutoSwitchQuality(true);
                player.seekTo(0);
            }, 'dummyparam');
            return result.value;
        } catch (error) {

            console.error(error)
        }

    }

    getPlayerQualities() {
        let quality_names = [];
        let qualities = browser.execute('return player.getQualities();').value;
        for (let quality of qualities) {
            quality_names.push(quality['name']);
        }
        return quality_names;
    }

  visitWithLocalstoreSetting(url){
      console.log(url)
    this.visit(url)
    if( this.browserHelper.waitForVisible(player, 5000)){
      browser.execute("localStorage.setItem(\'backend\', JSON.stringify('#{VideoPlayerData.player_type}'))")
      browser.execute('localStorage.setItem(\'lastAdDisplay\', 9999999999999)')
      browser.execute('localStorage.setItem(\'quality\', "")')
      browser.execute('localStorage.setItem(\'quality-bitrate\', 358879)')
      this.visit(url)

    } else {
      console.log('HTML did not load within 5 seconds')
    }
  }


  displayPlayerStats(){
    browser.moveToObject(player)
    browser.click(gear_button_css)
    browser.click(advanced_menu_css)
    browser.click(stats_toggle_css)

  }
}

module.exports = new PlayerPage();
