'use strict';

const PlayerPage = require('../../pages/PlayerPage');
const ApiRequest = require('../../utils/ApiRequest');
var fs = require("fs");

describe('player network test ', function () {

  before(function() {
    console.log("executing api request")
    ApiRequest.getStreamMetadata('monstercat')
  });

  beforeEach(function() {
    let options = {
      captureHeaders:true,

      captureContent:true,

      captureBinaryContent:true
    };
    browser.proxy.createHar(options);
    PlayerPage.visitWithLocalstoreSetting("https://betaplayer.twitch.tv?channel=monstercat");
    PlayerPage.displayPlayerStats()
  });

    it('Player sample test', function () {
      var unixtime_ms = new Date().getTime();
      while(new Date().getTime() < unixtime_ms + 1000) {
        // console.log("waiting for the player")
      }
      // console.log(ApiRequest.get_stream_metadata('monstercat'));
      PlayerPage.visit("https://betaplayer.twitch.tv?channel=monstercat");
      console.log(browser.proxy.getHar());
      fs.writeFile("/tmp/har1.txt", browser.proxy.getHar(), (err) => {
        if (err) {
          console.error(err);
          return;
        };
        console.log("File has been created");
      });
    });
});
