var request = require('sync-request');
var asyncRequest =  require('request');

class RequestHelper {

  /**
   * Makes synchronous request
   * @param method
   * @param url
   * @param headers
   * @param data
   * @param timeout
   */
  makeSyncRequest(method, url, headers = {}, data = {}, timeout = 10000) {
    return request(method, url, {
      headers:headers,
      json: data,
      timeout: timeout
    });
  }

  /**
   * Makes asynchronous request.
   * @param method
   * @param url
   * @param headers
   * @param data
   * @param callback
   */
  makeAsycnRequest(method, url, headers = {}, data = {}, callback= null) {
    let makeRequest = {
      url: url,
      method: method,
      headers,
      json: body,s
    };
    asyncRequest(makeRequest,function (error, response, body) {
      if (response && response.statusCode === 200) {
        return body;
      } else {
        throw `Aync Request failed for ${makeRequest.url} due to ${JSON.stringify(body)}`
      }
      
    });
  }
}

module.exports = new RequestHelper();
