# screen_resolution_console
A simple CLI for setting screen resolution on Windows.
This was primarily created so that [qe/grid](https://git.xarth.tv/qe/grid) can set the resolution.

This should be considered in beta, and not production ready.

# Supported Operating Systems
- Windows 10

# Operations

This CLI works in the context of:
`ResolutionConsole.exe <operation> <additional_arguments>`

Below details all of the valid operations.

## set
Sets the screen resolution of the current display running the CMD.

#### Required Arguments:
- `-width`
  - The width resolution to set
- `-height`
  - The height resolution to set

#### Example
`ResolutionConsole.exe set -width 1920 -height 1200`

## get
Gets the current screen resolution

#### Required Arguments:
None

#### Example
`ResolutionConsole.exe get`

## test
Tests all recorded resolutions of a display to see if they're valid.
This operation will take a few minutes, and will change your resolution repeatedly.

#### Required Arguments:
None

#### Example
`ResolutionConsole.exe test`

## Static Code Security Analysis
[nuget-security](https://git.xarth.tv/security/nuget-security) is installed for Static Code Security Analysis.
Package Name: Twitch.Security.Code.Scanner

This will display security errors in the Visual Studio Errors List.

You must install this on your local Nuget package repository - it's not longer provided on the internal nuget.
1) `mkdir -p ~/twitch/security && cd ~/twitch/security`
2) `git clone git@git.xarth.tv:security/nuget-security.git`
3) Navigate to [Github Releases 0.3.12](https://git.xarth.tv/security/nuget-security/releases/tag/v0.3.12) and download `Twitch.Security.Code.Scanner.0.3.12.nupkg`
4) `mv ~/Downloads/Twitch.Security.Code.Scanner.0.3.12.nupkg ~/twitch/security/nuget-security`
5) Add source in your local nuget following [these instructions](https://stackoverflow.com/questions/10240029/how-do-i-install-a-nuget-package-nupkg-file-locally)
