#!/bin/bash

APP_NAME="ResolutionConsole"
ZIP_NAME="$APP_NAME.zip"
ORIG_DIRECTORY=$(pwd)

echo "Launch visual studio, and build as release. Building from within this script is not currently supported."
# To build, tried msdot build, but it complains about not finding the target framework. Need to figure this out
read -p "Have you built the app? (y/n): " inputVal

# If user entered anything but y, exit.
if [ "$inputVal" != "y" ]
then
 echo "Exiting! Run again and make sure you type y when built"
 exit 1
fi

# Make a directory, copy all the build artifacts into it
mkdir $APP_NAME
cp bin/Release/* $APP_NAME

# Zip it up.
# Note, we're CD'ing in and zipping from within so that unzip will not include the parent folder.
# Grid expects the files to go into the unzip folder, not the parent directory with files embedded within.
cd $APP_NAME
zip -r "$ZIP_NAME" *
mv $ZIP_NAME $ORIG_DIRECTORY
cd $ORIG_DIRECTORY
rm -rf $APP_NAME

# Prepare to upload to AWS S3
read -p "What environment would you like to upload artifacts to? (dev/prod): " artifactEnvironment

# Make sure input was either dev or prod
if [ "$artifactEnvironment" != "dev" ] && [ "$artifactEnvironment" != "prod" ] ; then
  echo "Error in the inputted environment: $artifactEnvironment. Please enter either dev or prod"
  exit 1
fi

echo "Uploading to $artifactEnvironment"

S3Url="s3://grid-artifacts/$APP_NAME/$artifactEnvironment/$ZIP_NAME"
echo "S3 Path: $S3Url"
aws s3 cp "$ZIP_NAME" "$S3Url" --storage-class "ONEZONE_IA" --profile "twitch-browsergrid-prod" # Upload to AWS S3

rm $ZIP_NAME

echo "Done!"
