# smoca-cli
This is the command line interface for Smoca.  This allows for initialization of Smoca tests in a repo and setting up your environment for Smoca development.

# Installation
There are two ways to install `smoca-cli`.

If you want to add it to your repo (i.e. run via `yarn smoca`), then simply run:
```
yarn add smoca -D
```

If you want to install it globally (i.e. run via `smoca`), then run:
```
yarn global add smoca -D
```

# Usage
Various subcommands provide functionality.  They are as follows:

### smoca init
This will initialize a `smoca` directory in your current working directory.  It will be populated with all that's needed to get your repo setup for Smoca tests.  Generally, this only needs to be ran once per repo.

### smoca install
This will install Smoca and its dependencies based on the contents of the `smoca` directory in your current working directory.

### smoca run
Runs all Smoca tests that are in the `smoca/spec` directory in your current working directory.

**Options**
- `--parallel` true/false. Whether to run the Smoca tests in Parallel. Default: false
- `--max-processes` Int. The max amount of processes to run Smoca tests in Parallel. Default: undefined
- `--runtime-log` String. A file containing spec durations to help group them together onto processes. Default: undefined

# Local Development

The code is written in ES6 and utilizes `babel` to generate code that runs nicely in the node environment.  Therefore there's a couple extra steps needed in order to do stuff

### Running Locally
If you want to run the code you've developed locally, then run: `./run.sh $cmd $args`, where `$cmd` is the subcommand you want to run and `$args` are its args.  This is necessary because (since we're using babel), the run would otherwise need to be done via `yarn dev $cmd -- $args`.  The `run.sh` helps by removing the ugliness.

### Publishing Package
Whne you're ready to release a new version into the wild.  Publish the package to our [internal npm](https://git-aws.internal.justin.tv/twitch/docs/blob/master/release/private_npm.md) by doing the following:

* Up the version number in `package.json`.
* `npm set registry https://npm-registry-prod-def.internal.justin.tv`
* `npm login --registry` (username/password = `npm_user`, use `qeteam@justin.tv` as the email)
* `npm publish`

Ideally this will all be handled by a wrapper script in the future.  But for now - c'est la vie.

### Testing the Package Locally
If you would like to test distribution of the package via `yarn` in another repo, then you can do so without having to publish the package first.  Follow these steps to do so:

* Run `npm pack` in this project's repository.  This will generate a `.tgz` file in the directory.
* Enter the directory where you'd like to test the package.
* Run `yarn remove smoca` to remove the existing package.
* Run `yarn cache clean` - this will remove any cached `Smoca` packages.
* Run `yarn add $tarPath -D`.  Replace `$tarPath` with the path to the tar generated in the previous step.

You need to repeat these steps anytime you change the package locally and want to test the change.

# Firefox Dependency

Smoca runs by default on Mozilla Firefox. It must be on your system for Smoca to be able to run.

Install Firefox [45.7.0esr](https://ftp.mozilla.org/pub/firefox/releases/45.7.0esr/mac/en-US/).

**You must run a Firefox version less than 48.** Smoca does not support the latest version of Firefox. Follow progress on supporting latest versions of Firefox [here](https://twitchtv.atlassian.net/browse/SMOC-469).

#### Using Non-System Default Firefox
As a developer, you may want to use the latest Firefox version as the system default, but specify Smoca to use 45 ESR.

You can specify `SMOCA_FIREFOX_PATH` in your `~/.bash_profile` to point to a custom binary path for Smoca to use.

Example:

1. Download Firefox 45 ESR using the link in the section above
2. Move `Firefox.app` to `~/twitch/qa/smoca` instead of in `/Applications`
3. Configure your `SMOCA_FIREFOX_PATH` (below)

Add to your `.bash_profile`
```shell
export SMOCA_FIREFOX_PATH=~/twitch/qa/smoca/Firefox.app/Contents/MacOS/firefox-bin
```

Alternatively, run in your terminal:
```shell
echo 'export SMOCA_FIREFOX_PATH=~/twitch/qa/smoca/Firefox.app/Contents/MacOS/firefox-bin' >> ~/.bash_profile
```

These paths can be customize to wherever you'd prefer your Firefox 45 version.

Then, before running Smoca, run:
```shell
source ~/.bash_profile
```

#### Amazon ACME Compliance
If ACME informs you that you must update Firefox, you can open Firefox's auto-update, which will automatically update you to the latest 45ESR version.

Amazon supports older versions as long as they are ESR.
